/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;

public enum State {
    UNKNOWN,
    CREATING,
    ACTIVE,
    UPDATING,
    SCALING,
    COMMITTING_TXN,
    TRUNCATING,
    SEALING,
    SEALED;


    public static boolean isTransitionAllowed(State currentState, State newState) {
        return StateTransitions.valueOf(currentState.name()).transitions.contains((Object)newState);
    }

    private static enum StateTransitions {
        UNKNOWN(UNKNOWN, CREATING),
        CREATING(CREATING, ACTIVE),
        ACTIVE(ACTIVE, SCALING, TRUNCATING, COMMITTING_TXN, SEALING, SEALED, UPDATING),
        SCALING(SCALING, ACTIVE),
        COMMITTING_TXN(COMMITTING_TXN, ACTIVE),
        TRUNCATING(TRUNCATING, ACTIVE),
        UPDATING(UPDATING, ACTIVE),
        SEALING(SEALING, SEALED),
        SEALED(SEALED);

        private final Set<State> transitions;

        private StateTransitions(State ... states) {
            this.transitions = Sets.immutableEnumSet(Arrays.asList(states));
        }
    }
}

