/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.retryable.RetryableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreException
extends RuntimeException {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StoreException.class);

    private StoreException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public static StoreException create(Type type, Throwable cause) {
        Preconditions.checkNotNull((Object)cause, (Object)"cause");
        return StoreException.create(type, cause, null);
    }

    public static StoreException create(Type type, String errorMessage) {
        Exceptions.checkNotNullOrEmpty((String)errorMessage, (String)"errorMessage");
        return StoreException.create(type, null, errorMessage);
    }

    public static StoreException create(Type type, Throwable cause, String errorMessage) {
        StoreException exception;
        Preconditions.checkArgument((cause != null || errorMessage != null && !errorMessage.isEmpty() ? 1 : 0) != 0, (Object)"Either cause or errorMessage should be non-empty");
        switch (type) {
            case DATA_EXISTS: {
                exception = new DataExistsException(errorMessage, cause);
                break;
            }
            case DATA_NOT_FOUND: {
                exception = new DataNotFoundException(errorMessage, cause);
                break;
            }
            case DATA_CONTAINS_ELEMENTS: {
                exception = new DataNotEmptyException(errorMessage, cause);
                break;
            }
            case WRITE_CONFLICT: {
                exception = new WriteConflictException(errorMessage, cause);
                break;
            }
            case ILLEGAL_STATE: {
                exception = new IllegalStateException(errorMessage, cause);
                break;
            }
            case OPERATION_NOT_ALLOWED: {
                exception = new OperationNotAllowedException(errorMessage, cause);
                break;
            }
            case CONNECTION_ERROR: {
                exception = new StoreConnectionException(errorMessage, cause);
                break;
            }
            case UNKNOWN: {
                exception = new UnknownException(errorMessage, cause);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid exception type");
            }
        }
        return exception;
    }

    public static class UnknownException
    extends StoreException {
        private UnknownException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class StoreConnectionException
    extends StoreException
    implements RetryableException {
        private StoreConnectionException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class OperationNotAllowedException
    extends StoreException {
        private OperationNotAllowedException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class IllegalStateException
    extends StoreException {
        private IllegalStateException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class WriteConflictException
    extends StoreException
    implements RetryableException {
        private WriteConflictException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class DataNotEmptyException
    extends StoreException {
        private DataNotEmptyException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class DataNotFoundException
    extends StoreException {
        private DataNotFoundException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class DataExistsException
    extends StoreException {
        private DataExistsException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static enum Type {
        DATA_EXISTS,
        DATA_NOT_FOUND,
        DATA_CONTAINS_ELEMENTS,
        WRITE_CONFLICT,
        ILLEGAL_STATE,
        OPERATION_NOT_ALLOWED,
        CONNECTION_ERROR,
        UNKNOWN;

    }
}

