/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import io.pravega.client.stream.StreamConfiguration;
import io.pravega.controller.store.stream.CreateStreamResponse;
import io.pravega.controller.store.stream.OperationContext;
import io.pravega.controller.store.stream.ScaleMetadata;
import io.pravega.controller.store.stream.State;
import io.pravega.controller.store.stream.TxnStatus;
import io.pravega.controller.store.stream.Version;
import io.pravega.controller.store.stream.VersionedMetadata;
import io.pravega.controller.store.stream.VersionedTransactionData;
import io.pravega.controller.store.stream.WriterTimestampResponse;
import io.pravega.controller.store.stream.records.ActiveTxnRecord;
import io.pravega.controller.store.stream.records.CommittingTransactionsRecord;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.RetentionSet;
import io.pravega.controller.store.stream.records.StreamConfigurationRecord;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.controller.store.stream.records.StreamTruncationRecord;
import io.pravega.controller.store.stream.records.WriterMark;
import io.pravega.controller.store.task.TxnResource;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.controller.event.ControllerEvent;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.tuple.Pair;

public interface StreamMetadataStore
extends AutoCloseable {
    public OperationContext createContext(String var1, String var2);

    public CompletableFuture<CreateStreamResponse> createStream(String var1, String var2, StreamConfiguration var3, long var4, OperationContext var6, Executor var7);

    public CompletableFuture<Boolean> checkStreamExists(String var1, String var2);

    public CompletableFuture<Long> getCreationTime(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Void> deleteStream(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Void> setState(String var1, String var2, State var3, OperationContext var4, Executor var5);

    public CompletableFuture<State> getState(String var1, String var2, boolean var3, OperationContext var4, Executor var5);

    public CompletableFuture<VersionedMetadata<State>> getVersionedState(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<VersionedMetadata<State>> updateVersionedState(String var1, String var2, State var3, VersionedMetadata<State> var4, OperationContext var5, Executor var6);

    public CompletableFuture<Controller.CreateScopeStatus> createScope(String var1);

    public CompletableFuture<Controller.DeleteScopeStatus> deleteScope(String var1);

    public CompletableFuture<String> getScopeConfiguration(String var1);

    public CompletableFuture<Map<String, StreamConfiguration>> listStreamsInScope(String var1);

    public CompletableFuture<Pair<List<String>, String>> listStream(String var1, String var2, int var3, Executor var4);

    public CompletableFuture<List<String>> listScopes();

    public CompletableFuture<Void> startUpdateConfiguration(String var1, String var2, StreamConfiguration var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> completeUpdateConfiguration(String var1, String var2, VersionedMetadata<StreamConfigurationRecord> var3, OperationContext var4, Executor var5);

    public CompletableFuture<StreamConfiguration> getConfiguration(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<VersionedMetadata<StreamConfigurationRecord>> getConfigurationRecord(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Void> startTruncation(String var1, String var2, Map<Long, Long> var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> completeTruncation(String var1, String var2, VersionedMetadata<StreamTruncationRecord> var3, OperationContext var4, Executor var5);

    public CompletableFuture<VersionedMetadata<StreamTruncationRecord>> getTruncationRecord(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Void> setSealed(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Boolean> isSealed(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<StreamSegmentRecord> getSegment(String var1, String var2, long var3, OperationContext var5, Executor var6);

    public CompletableFuture<Set<Long>> getAllSegmentIds(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<List<StreamSegmentRecord>> getActiveSegments(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Map<StreamSegmentRecord, Long>> getSegmentsAtHead(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsInEpoch(String var1, String var2, int var3, OperationContext var4, Executor var5);

    public CompletableFuture<Map<StreamSegmentRecord, List<Long>>> getSuccessors(String var1, String var2, long var3, OperationContext var5, Executor var6);

    public CompletableFuture<List<StreamSegmentRecord>> getSegmentsBetweenStreamCuts(String var1, String var2, Map<Long, Long> var3, Map<Long, Long> var4, OperationContext var5, Executor var6);

    public CompletableFuture<Boolean> isStreamCutValid(String var1, String var2, Map<Long, Long> var3, OperationContext var4, Executor var5);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> getEpochTransition(String var1, String var2, OperationContext var3, ScheduledExecutorService var4);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> submitScale(String var1, String var2, List<Long> var3, List<Map.Entry<Double, Double>> var4, long var5, VersionedMetadata<EpochTransitionRecord> var7, OperationContext var8, Executor var9);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> startScale(String var1, String var2, boolean var3, VersionedMetadata<EpochTransitionRecord> var4, VersionedMetadata<State> var5, OperationContext var6, Executor var7);

    public CompletableFuture<VersionedMetadata<EpochTransitionRecord>> scaleCreateNewEpochs(String var1, String var2, VersionedMetadata<EpochTransitionRecord> var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> scaleSegmentsSealed(String var1, String var2, Map<Long, Long> var3, VersionedMetadata<EpochTransitionRecord> var4, OperationContext var5, Executor var6);

    public CompletableFuture<Void> completeScale(String var1, String var2, VersionedMetadata<EpochTransitionRecord> var3, OperationContext var4, Executor var5);

    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> startRollingTxn(String var1, String var2, int var3, VersionedMetadata<CommittingTransactionsRecord> var4, OperationContext var5, ScheduledExecutorService var6);

    public CompletableFuture<Void> rollingTxnCreateDuplicateEpochs(String var1, String var2, Map<Long, Long> var3, long var4, VersionedMetadata<CommittingTransactionsRecord> var6, OperationContext var7, Executor var8);

    public CompletableFuture<Void> completeRollingTxn(String var1, String var2, Map<Long, Long> var3, VersionedMetadata<CommittingTransactionsRecord> var4, OperationContext var5, Executor var6);

    public CompletableFuture<UUID> generateTransactionId(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<VersionedTransactionData> createTransaction(String var1, String var2, UUID var3, long var4, long var6, OperationContext var8, Executor var9);

    public CompletableFuture<VersionedTransactionData> pingTransaction(String var1, String var2, VersionedTransactionData var3, long var4, OperationContext var6, Executor var7);

    public CompletableFuture<VersionedTransactionData> getTransactionData(String var1, String var2, UUID var3, OperationContext var4, Executor var5);

    public CompletableFuture<TxnStatus> transactionStatus(String var1, String var2, UUID var3, OperationContext var4, Executor var5);

    public CompletableFuture<AbstractMap.SimpleEntry<TxnStatus, Integer>> sealTransaction(String var1, String var2, UUID var3, boolean var4, Optional<Version> var5, String var6, long var7, OperationContext var9, Executor var10);

    public CompletableFuture<TxnStatus> abortTransaction(String var1, String var2, UUID var3, OperationContext var4, Executor var5);

    public CompletableFuture<Map<UUID, ActiveTxnRecord>> getActiveTxns(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<Void> addTxnToIndex(String var1, TxnResource var2, Version var3);

    public CompletableFuture<Void> removeTxnFromIndex(String var1, TxnResource var2, boolean var3);

    public CompletableFuture<Optional<TxnResource>> getRandomTxnFromIndex(String var1);

    public CompletableFuture<Version> getTxnVersionFromIndex(String var1, TxnResource var2);

    public CompletableFuture<Void> removeHostFromIndex(String var1);

    public CompletableFuture<Set<String>> listHostsOwningTxn();

    public CompletableFuture<Void> addRequestToIndex(String var1, String var2, ControllerEvent var3);

    public CompletableFuture<Void> removeTaskFromIndex(String var1, String var2);

    public CompletableFuture<Map<String, ControllerEvent>> getPendingsTaskForHost(String var1, int var2);

    public CompletableFuture<Void> removeHostFromTaskIndex(String var1);

    public CompletableFuture<Set<String>> listHostsWithPendingTask();

    public CompletableFuture<EpochRecord> getActiveEpoch(String var1, String var2, OperationContext var3, boolean var4, Executor var5);

    public CompletableFuture<EpochRecord> getEpoch(String var1, String var2, int var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> markCold(String var1, String var2, long var3, long var5, OperationContext var7, Executor var8);

    public CompletableFuture<Boolean> isCold(String var1, String var2, long var3, OperationContext var5, Executor var6);

    public CompletableFuture<Void> removeMarker(String var1, String var2, long var3, OperationContext var5, Executor var6);

    public CompletableFuture<List<ScaleMetadata>> getScaleMetadata(String var1, String var2, long var3, long var5, OperationContext var7, Executor var8);

    public CompletableFuture<Void> addStreamCutToRetentionSet(String var1, String var2, StreamCutRecord var3, OperationContext var4, Executor var5);

    public CompletableFuture<RetentionSet> getRetentionSet(String var1, String var2, OperationContext var3, Executor var4);

    public CompletableFuture<StreamCutRecord> getStreamCutRecord(String var1, String var2, StreamCutReferenceRecord var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> deleteStreamCutBefore(String var1, String var2, StreamCutReferenceRecord var3, OperationContext var4, Executor var5);

    public CompletableFuture<Long> getSizeTillStreamCut(String var1, String var2, Map<Long, Long> var3, Optional<StreamCutRecord> var4, OperationContext var5, ScheduledExecutorService var6);

    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> startCommitTransactions(String var1, String var2, OperationContext var3, ScheduledExecutorService var4);

    public CompletableFuture<VersionedMetadata<CommittingTransactionsRecord>> getVersionedCommittingTransactionsRecord(String var1, String var2, OperationContext var3, ScheduledExecutorService var4);

    public CompletableFuture<Void> completeCommitTransactions(String var1, String var2, VersionedMetadata<CommittingTransactionsRecord> var3, OperationContext var4, ScheduledExecutorService var5);

    public CompletableFuture<Void> recordCommitOffsets(String var1, String var2, UUID var3, Map<Long, Long> var4, OperationContext var5, ScheduledExecutorService var6);

    public CompletableFuture<Void> createWaitingRequestIfAbsent(String var1, String var2, String var3, OperationContext var4, ScheduledExecutorService var5);

    public CompletableFuture<String> getWaitingRequestProcessor(String var1, String var2, OperationContext var3, ScheduledExecutorService var4);

    public CompletableFuture<Void> deleteWaitingRequestConditionally(String var1, String var2, String var3, OperationContext var4, ScheduledExecutorService var5);

    public CompletableFuture<WriterTimestampResponse> noteWriterMark(String var1, String var2, String var3, long var4, Map<Long, Long> var6, OperationContext var7, Executor var8);

    public CompletableFuture<Void> shutdownWriter(String var1, String var2, String var3, OperationContext var4, Executor var5);

    public CompletableFuture<Void> removeWriter(String var1, String var2, String var3, WriterMark var4, OperationContext var5, Executor var6);

    public CompletableFuture<WriterMark> getWriterMark(String var1, String var2, String var3, OperationContext var4, Executor var5);

    public CompletableFuture<Map<String, WriterMark>> getAllWriterMarks(String var1, String var2, OperationContext var3, Executor var4);
}

