/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.impl.KeyVersionImpl;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;

public interface Version {
    public IntVersion asIntVersion();

    public LongVersion asLongVersion();

    public byte[] toBytes();

    public static class LongVersionSerializer
    extends VersionedSerializer.WithBuilder<LongVersion, LongVersion.LongVersionBuilder> {
        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, LongVersion.LongVersionBuilder builder) throws IOException {
            builder.longValue(revisionDataInput.readLong());
        }

        private void write00(LongVersion record, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(record.getLongValue());
        }

        protected LongVersion.LongVersionBuilder newBuilder() {
            return LongVersion.builder();
        }
    }

    public static class LongVersion
    extends UnsupportedVersion {
        public static final LongVersion EMPTY = LongVersion.builder().longValue(KeyVersionImpl.NOT_EXISTS.getSegmentVersion()).build();
        static final LongVersionSerializer SERIALIZER = new LongVersionSerializer();
        private final long longValue;

        @Override
        public LongVersion asLongVersion() {
            return this;
        }

        @Override
        public byte[] toBytes() {
            return SERIALIZER.serialize(this).getCopy();
        }

        public static LongVersion fromBytes(byte[] data) {
            return (LongVersion)SERIALIZER.deserialize(data);
        }

        @ConstructorProperties(value={"longValue"})
        @SuppressFBWarnings(justification="generated code")
        LongVersion(long longValue) {
            this.longValue = longValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public static LongVersionBuilder builder() {
            return new LongVersionBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public long getLongValue() {
            return this.longValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "Version.LongVersion(longValue=" + this.getLongValue() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongVersion)) {
                return false;
            }
            LongVersion other = (LongVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getLongValue() == other.getLongValue();
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof LongVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $longValue = this.getLongValue();
            result = result * 59 + (int)($longValue >>> 32 ^ $longValue);
            return result;
        }

        public static class LongVersionBuilder
        implements ObjectBuilder<LongVersion> {
            @SuppressFBWarnings(justification="generated code")
            private long longValue;

            @SuppressFBWarnings(justification="generated code")
            LongVersionBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public LongVersionBuilder longValue(long longValue) {
                this.longValue = longValue;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public LongVersion build() {
                return new LongVersion(this.longValue);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "Version.LongVersion.LongVersionBuilder(longValue=" + this.longValue + ")";
            }
        }
    }

    public static class IntVersionSerializer
    extends VersionedSerializer.WithBuilder<IntVersion, IntVersion.IntVersionBuilder> {
        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, IntVersion.IntVersionBuilder builder) throws IOException {
            builder.intValue(revisionDataInput.readInt());
        }

        private void write00(IntVersion record, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(record.getIntValue());
        }

        protected IntVersion.IntVersionBuilder newBuilder() {
            return IntVersion.builder();
        }
    }

    public static class IntVersion
    extends UnsupportedVersion {
        public static final IntVersion EMPTY = IntVersion.builder().intValue(Integer.MIN_VALUE).build();
        static final IntVersionSerializer SERIALIZER = new IntVersionSerializer();
        private final int intValue;

        @Override
        public IntVersion asIntVersion() {
            return this;
        }

        @Override
        public byte[] toBytes() {
            return SERIALIZER.serialize(this).getCopy();
        }

        public static IntVersion fromBytes(byte[] data) {
            return (IntVersion)SERIALIZER.deserialize(data);
        }

        @ConstructorProperties(value={"intValue"})
        @SuppressFBWarnings(justification="generated code")
        IntVersion(int intValue) {
            this.intValue = intValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public static IntVersionBuilder builder() {
            return new IntVersionBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public int getIntValue() {
            return this.intValue;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "Version.IntVersion(intValue=" + this.getIntValue() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntVersion)) {
                return false;
            }
            IntVersion other = (IntVersion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getIntValue() == other.getIntValue();
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof IntVersion;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIntValue();
            return result;
        }

        public static class IntVersionBuilder
        implements ObjectBuilder<IntVersion> {
            @SuppressFBWarnings(justification="generated code")
            private int intValue;

            @SuppressFBWarnings(justification="generated code")
            IntVersionBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public IntVersionBuilder intValue(int intValue) {
                this.intValue = intValue;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public IntVersion build() {
                return new IntVersion(this.intValue);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "Version.IntVersion.IntVersionBuilder(intValue=" + this.intValue + ")";
            }
        }
    }

    public static abstract class UnsupportedVersion
    implements Version {
        @Override
        public IntVersion asIntVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LongVersion asLongVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] toBytes() {
            throw new UnsupportedOperationException();
        }
    }
}

