/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.Scope;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.ZKStoreHelper;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.curator.utils.ZKPaths;

public class ZKScope
implements Scope {
    static final String STREAMS_IN_SCOPE = "_streamsinscope";
    private static final String SCOPE_PATH = "/store/%s";
    private static final String STREAMS_IN_SCOPE_ROOT_PATH = "/store/_streamsinscope/%s";
    private static final String STREAMS_IN_SCOPE_ROOT_PATH_FORMAT = "/store/_streamsinscope/%s/streams";
    private static final String COUNTER_PATH = "/store/_streamsinscope/%s/counter";
    private static final Predicate<Throwable> DATA_NOT_FOUND_PREDICATE = e -> Exceptions.unwrap((Throwable)e) instanceof StoreException.DataNotFoundException;
    private final String scopePath;
    private final String counterPath;
    private final String streamsInScopePath;
    private final String scopeName;
    private final ZKStoreHelper store;

    ZKScope(String scopeName, ZKStoreHelper store) {
        this.scopeName = scopeName;
        this.store = store;
        this.scopePath = String.format(SCOPE_PATH, scopeName);
        this.counterPath = String.format(COUNTER_PATH, scopeName);
        this.streamsInScopePath = String.format(STREAMS_IN_SCOPE_ROOT_PATH_FORMAT, scopeName);
    }

    @Override
    public String getName() {
        return this.scopeName;
    }

    @Override
    public CompletableFuture<Void> createScope() {
        return this.store.addNode(this.scopePath);
    }

    @Override
    public CompletableFuture<Void> deleteScope() {
        return ((CompletableFuture)this.store.deleteNode(this.scopePath).thenCompose(v -> Futures.exceptionallyExpecting(this.store.deleteTree(this.counterPath), DATA_NOT_FOUND_PREDICATE, null))).thenCompose(v -> Futures.exceptionallyExpecting(this.store.deleteTree(this.streamsInScopePath), DATA_NOT_FOUND_PREDICATE, null));
    }

    CompletableFuture<Void> addStreamToScope(String name, int streamPosition) {
        String path = this.getPathForStreamPosition(name, streamPosition);
        return Futures.toVoid(this.store.createZNodeIfNotExist(path));
    }

    CompletableFuture<Void> removeStreamFromScope(String name, int streamPosition) {
        String path = this.getPathForStreamPosition(name, streamPosition);
        return Futures.toVoid(this.store.deletePath(path, true));
    }

    private String getPathForStreamPosition(String name, int streamPosition) {
        Preconditions.checkArgument((streamPosition >= 0 ? 1 : 0) != 0);
        Token token = new Token(streamPosition);
        String root = ZKPaths.makePath((String)this.streamsInScopePath, (String)token.getMsb().toString());
        String container = ZKPaths.makePath((String)root, (String)token.getMiddle().toString());
        return ZKPaths.makePath((String)container, (String)String.format("%s%04d", name, token.getLsb()));
    }

    private String getStreamName(String x) {
        return x.substring(0, x.length() - 4);
    }

    private int getPosition(String x) {
        return Integer.parseInt(x.substring(x.length() - 4, x.length()));
    }

    @Override
    public CompletableFuture<List<String>> listStreamsInScope() {
        return this.store.getChildren(this.scopePath, false);
    }

    @Override
    public CompletableFuture<Pair<List<String>, String>> listStreams(int limit, String continuationToken, Executor executor) {
        LinkedList toReturn = new LinkedList();
        AtomicInteger remaining = new AtomicInteger(limit);
        Token floor = Token.fromString(continuationToken);
        AtomicReference<Token> lastPos = new AtomicReference<Token>(floor);
        return this.computeOnChildren(this.streamsInScopePath, topChild -> {
            if (topChild >= floor.getMsb()) {
                String topPath = ZKPaths.makePath((String)this.streamsInScopePath, (String)topChild.toString());
                int middleFloor = topChild.intValue() == floor.getMsb().intValue() ? floor.getMiddle() : 0;
                CompletableFuture<Void> voidCompletableFuture = this.computeOnChildren(topPath, middleChild -> {
                    if (middleChild >= middleFloor) {
                        String middlePath = ZKPaths.makePath((String)topPath, (String)middleChild.toString());
                        return ((CompletableFuture)this.store.getChildren(middlePath).thenAccept(streams -> {
                            int bottomFloor = topChild.intValue() == floor.getMsb().intValue() && middleChild.intValue() == floor.getMiddle().intValue() ? floor.getLsb() : -1;
                            Pair<List<String>, Integer> retVal = this.filterStreams((List<String>)streams, bottomFloor, remaining.get());
                            if (!((List)retVal.getKey()).isEmpty()) {
                                toReturn.addAll((Collection)retVal.getKey());
                                remaining.set(limit - toReturn.size());
                                lastPos.set(new Token((int)topChild, (int)middleChild, (Integer)retVal.getValue()));
                            }
                        })).thenApply(v -> remaining.get() > 0);
                    }
                    return CompletableFuture.completedFuture(true);
                }, executor);
                return voidCompletableFuture.thenApply(v -> remaining.get() > 0);
            }
            return CompletableFuture.completedFuture(true);
        }, executor).thenApply(v -> new ImmutablePair((Object)toReturn, (Object)((Token)lastPos.get()).toString()));
    }

    private Pair<List<String>, Integer> filterStreams(List<String> streams, int bottomFloor, int limit) {
        AtomicReference<Integer> last = new AtomicReference<Integer>(bottomFloor);
        List list = streams.stream().filter(x -> bottomFloor < this.getPosition((String)x)).sorted(Comparator.comparingInt(this::getPosition)).limit(limit).collect(Collectors.toList());
        List toReturn = list.stream().map(x -> {
            int streamPosition = this.getPosition((String)x);
            if (streamPosition > (Integer)last.get()) {
                last.set(streamPosition);
            }
            return this.getStreamName((String)x);
        }).collect(Collectors.toList());
        return new ImmutablePair(toReturn, (Object)last.get());
    }

    @Override
    public void refresh() {
    }

    CompletableFuture<Integer> getNextStreamPosition() {
        return this.store.createEphemeralSequentialZNode(this.counterPath).thenApply(counterStr -> Integer.parseInt(counterStr.replace(this.counterPath, "")));
    }

    private CompletableFuture<Void> computeOnChildren(String path, Function<Integer, CompletableFuture<Boolean>> function, Executor executor) {
        return this.store.getChildren(path, false).thenCompose(children -> {
            AtomicInteger index = new AtomicInteger(0);
            AtomicBoolean continueLoop = new AtomicBoolean(!children.isEmpty());
            List list = children.stream().map(Integer::parseInt).sorted().collect(Collectors.toList());
            return Futures.loop(continueLoop::get, () -> ((CompletableFuture)function.apply((Integer)list.get(index.get()))).thenAccept(canContinue -> continueLoop.set(canContinue != false && index.incrementAndGet() < children.size())), (Executor)executor);
        });
    }

    private static class Token {
        static final Token EMPTY = new Token(0, 0, -1);
        static final TokenSerializer SERIALIZER = new TokenSerializer();
        private final Integer msb;
        private final Integer middle;
        private final Integer lsb;

        Token(int msb, int middle, int lsb) {
            Preconditions.checkArgument((msb >= 0 && msb < 100 ? 1 : 0) != 0);
            Preconditions.checkArgument((middle >= 0 && middle < 10000 ? 1 : 0) != 0);
            Preconditions.checkArgument((lsb < 10000 ? 1 : 0) != 0);
            this.msb = msb;
            this.middle = middle;
            this.lsb = lsb;
        }

        Token(int position) {
            Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0);
            String withPadding = String.format("%010d", position);
            this.msb = Integer.parseInt(withPadding.substring(0, 2));
            this.middle = Integer.parseInt(withPadding.substring(2, 6));
            this.lsb = Integer.parseInt(withPadding.substring(6, 10));
        }

        static Token fromString(String token) {
            if (Strings.isNullOrEmpty((String)token)) {
                return EMPTY;
            }
            return (Token)SERIALIZER.deserialize(Base64.getDecoder().decode(token));
        }

        public String toString() {
            return Base64.getEncoder().encodeToString(SERIALIZER.serialize(this).getCopy());
        }

        @SuppressFBWarnings(justification="generated code")
        public static TokenBuilder builder() {
            return new TokenBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public Integer getMsb() {
            return this.msb;
        }

        @SuppressFBWarnings(justification="generated code")
        public Integer getMiddle() {
            return this.middle;
        }

        @SuppressFBWarnings(justification="generated code")
        public Integer getLsb() {
            return this.lsb;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$msb = this.getMsb();
            Integer other$msb = other.getMsb();
            if (this$msb == null ? other$msb != null : !((Object)this$msb).equals(other$msb)) {
                return false;
            }
            Integer this$middle = this.getMiddle();
            Integer other$middle = other.getMiddle();
            if (this$middle == null ? other$middle != null : !((Object)this$middle).equals(other$middle)) {
                return false;
            }
            Integer this$lsb = this.getLsb();
            Integer other$lsb = other.getLsb();
            return !(this$lsb == null ? other$lsb != null : !((Object)this$lsb).equals(other$lsb));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof Token;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $msb = this.getMsb();
            result = result * 59 + ($msb == null ? 43 : ((Object)$msb).hashCode());
            Integer $middle = this.getMiddle();
            result = result * 59 + ($middle == null ? 43 : ((Object)$middle).hashCode());
            Integer $lsb = this.getLsb();
            result = result * 59 + ($lsb == null ? 43 : ((Object)$lsb).hashCode());
            return result;
        }

        static class TokenSerializer
        extends VersionedSerializer.WithBuilder<Token, TokenBuilder> {
            TokenSerializer() {
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput revisionDataInput, TokenBuilder builder) throws IOException {
                builder.msb(revisionDataInput.readCompactInt()).middle(revisionDataInput.readCompactInt()).lsb((int)revisionDataInput.readCompactSignedLong());
            }

            private void write00(Token token, RevisionDataOutput revisionDataOutput) throws IOException {
                revisionDataOutput.writeCompactInt(token.msb.intValue());
                revisionDataOutput.writeCompactInt(token.middle.intValue());
                revisionDataOutput.writeCompactSignedLong((long)token.lsb.intValue());
            }

            protected TokenBuilder newBuilder() {
                return Token.builder();
            }
        }

        static class TokenBuilder
        implements ObjectBuilder<Token> {
            @SuppressFBWarnings(justification="generated code")
            private int msb;
            @SuppressFBWarnings(justification="generated code")
            private int middle;
            @SuppressFBWarnings(justification="generated code")
            private int lsb;

            @SuppressFBWarnings(justification="generated code")
            TokenBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public TokenBuilder msb(int msb) {
                this.msb = msb;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public TokenBuilder middle(int middle) {
                this.middle = middle;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public TokenBuilder lsb(int lsb) {
                this.lsb = lsb;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public Token build() {
                return new Token(this.msb, this.middle, this.lsb);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ZKScope.Token.TokenBuilder(msb=" + this.msb + ", middle=" + this.middle + ", lsb=" + this.lsb + ")";
            }
        }
    }
}

