/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.TxnStatus;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedTxnRecord {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(CompletedTxnRecord.class);
    public static final CompletedTxnRecordSerializer SERIALIZER = new CompletedTxnRecordSerializer();
    private final long completeTime;
    private final TxnStatus completionStatus;

    public static CompletedTxnRecord fromBytes(byte[] data) {
        return (CompletedTxnRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static CompletedTxnRecordBuilder builder() {
        return new CompletedTxnRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public long getCompleteTime() {
        return this.completeTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public TxnStatus getCompletionStatus() {
        return this.completionStatus;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompletedTxnRecord)) {
            return false;
        }
        CompletedTxnRecord other = (CompletedTxnRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCompleteTime() != other.getCompleteTime()) {
            return false;
        }
        TxnStatus this$completionStatus = this.getCompletionStatus();
        TxnStatus other$completionStatus = other.getCompletionStatus();
        return !(this$completionStatus == null ? other$completionStatus != null : !((Object)((Object)this$completionStatus)).equals((Object)other$completionStatus));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof CompletedTxnRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $completeTime = this.getCompleteTime();
        result = result * 59 + (int)($completeTime >>> 32 ^ $completeTime);
        TxnStatus $completionStatus = this.getCompletionStatus();
        result = result * 59 + ($completionStatus == null ? 43 : ((Object)((Object)$completionStatus)).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "CompletedTxnRecord(completeTime=" + this.getCompleteTime() + ", completionStatus=" + (Object)((Object)this.getCompletionStatus()) + ")";
    }

    @ConstructorProperties(value={"completeTime", "completionStatus"})
    @SuppressFBWarnings(justification="generated code")
    public CompletedTxnRecord(long completeTime, TxnStatus completionStatus) {
        this.completeTime = completeTime;
        this.completionStatus = completionStatus;
    }

    private static class CompletedTxnRecordSerializer
    extends VersionedSerializer.WithBuilder<CompletedTxnRecord, CompletedTxnRecordBuilder> {
        private CompletedTxnRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, CompletedTxnRecordBuilder completedTxnRecordBuilder) throws IOException {
            completedTxnRecordBuilder.completeTime(revisionDataInput.readLong()).completionStatus(TxnStatus.values()[revisionDataInput.readCompactInt()]);
        }

        private void write00(CompletedTxnRecord completedTxnRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(completedTxnRecord.getCompleteTime());
            revisionDataOutput.writeCompactInt(completedTxnRecord.getCompletionStatus().ordinal());
        }

        protected CompletedTxnRecordBuilder newBuilder() {
            return CompletedTxnRecord.builder();
        }
    }

    public static class CompletedTxnRecordBuilder
    implements ObjectBuilder<CompletedTxnRecord> {
        @SuppressFBWarnings(justification="generated code")
        private long completeTime;
        @SuppressFBWarnings(justification="generated code")
        private TxnStatus completionStatus;

        @SuppressFBWarnings(justification="generated code")
        CompletedTxnRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public CompletedTxnRecordBuilder completeTime(long completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompletedTxnRecordBuilder completionStatus(TxnStatus completionStatus) {
            this.completionStatus = completionStatus;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public CompletedTxnRecord build() {
            return new CompletedTxnRecord(this.completeTime, this.completionStatus);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "CompletedTxnRecord.CompletedTxnRecordBuilder(completeTime=" + this.completeTime + ", completionStatus=" + (Object)((Object)this.completionStatus) + ")";
        }
    }
}

