/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class EpochTransitionRecord {
    public static final EpochTransitionRecordSerializer SERIALIZER = new EpochTransitionRecordSerializer();
    public static final EpochTransitionRecord EMPTY = new EpochTransitionRecord(Integer.MIN_VALUE, Long.MIN_VALUE, (ImmutableSet<Long>)ImmutableSet.of(), (ImmutableMap<Long, Map.Entry<Double, Double>>)ImmutableMap.of());
    final int activeEpoch;
    final long time;
    final ImmutableSet<Long> segmentsToSeal;
    final ImmutableMap<Long, Map.Entry<Double, Double>> newSegmentsWithRange;

    public EpochTransitionRecord(int activeEpoch, long time, @NonNull ImmutableSet<Long> segmentsToSeal, @NonNull ImmutableMap<Long, Map.Entry<Double, Double>> newSegmentsWithRange) {
        if (segmentsToSeal == null) {
            throw new NullPointerException("segmentsToSeal is marked @NonNull but is null");
        }
        if (newSegmentsWithRange == null) {
            throw new NullPointerException("newSegmentsWithRange is marked @NonNull but is null");
        }
        this.activeEpoch = activeEpoch;
        this.time = time;
        this.segmentsToSeal = segmentsToSeal;
        this.newSegmentsWithRange = newSegmentsWithRange;
    }

    public int getNewEpoch() {
        return this.activeEpoch + 1;
    }

    public static EpochTransitionRecord fromBytes(byte[] data) {
        return (EpochTransitionRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static EpochTransitionRecordBuilder builder() {
        return new EpochTransitionRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getActiveEpoch() {
        return this.activeEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTime() {
        return this.time;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<Long> getSegmentsToSeal() {
        return this.segmentsToSeal;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<Long, Map.Entry<Double, Double>> getNewSegmentsWithRange() {
        return this.newSegmentsWithRange;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EpochTransitionRecord)) {
            return false;
        }
        EpochTransitionRecord other = (EpochTransitionRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getActiveEpoch() != other.getActiveEpoch()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        ImmutableSet<Long> this$segmentsToSeal = this.getSegmentsToSeal();
        ImmutableSet<Long> other$segmentsToSeal = other.getSegmentsToSeal();
        if (this$segmentsToSeal == null ? other$segmentsToSeal != null : !this$segmentsToSeal.equals(other$segmentsToSeal)) {
            return false;
        }
        ImmutableMap<Long, Map.Entry<Double, Double>> this$newSegmentsWithRange = this.getNewSegmentsWithRange();
        ImmutableMap<Long, Map.Entry<Double, Double>> other$newSegmentsWithRange = other.getNewSegmentsWithRange();
        return !(this$newSegmentsWithRange == null ? other$newSegmentsWithRange != null : !this$newSegmentsWithRange.equals(other$newSegmentsWithRange));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof EpochTransitionRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getActiveEpoch();
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        ImmutableSet<Long> $segmentsToSeal = this.getSegmentsToSeal();
        result = result * 59 + ($segmentsToSeal == null ? 43 : $segmentsToSeal.hashCode());
        ImmutableMap<Long, Map.Entry<Double, Double>> $newSegmentsWithRange = this.getNewSegmentsWithRange();
        result = result * 59 + ($newSegmentsWithRange == null ? 43 : $newSegmentsWithRange.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "EpochTransitionRecord(activeEpoch=" + this.getActiveEpoch() + ", time=" + this.getTime() + ", segmentsToSeal=" + this.getSegmentsToSeal() + ", newSegmentsWithRange=" + this.getNewSegmentsWithRange() + ")";
    }

    private static class EpochTransitionRecordSerializer
    extends VersionedSerializer.WithBuilder<EpochTransitionRecord, EpochTransitionRecordBuilder> {
        private EpochTransitionRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, EpochTransitionRecordBuilder epochTransitionRecordBuilder) throws IOException {
            epochTransitionRecordBuilder.activeEpoch(revisionDataInput.readInt()).time(revisionDataInput.readLong());
            ImmutableSet.Builder segmentsToSealBuilder = ImmutableSet.builder();
            revisionDataInput.readCollection(DataInput::readLong, (ImmutableCollection.Builder)segmentsToSealBuilder);
            epochTransitionRecordBuilder.segmentsToSeal((ImmutableSet<Long>)segmentsToSealBuilder.build());
            ImmutableMap.Builder builder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, this::readValue, builder);
            epochTransitionRecordBuilder.newSegmentsWithRange((ImmutableMap<Long, Map.Entry<Double, Double>>)builder.build()).build();
        }

        private Map.Entry<Double, Double> readValue(RevisionDataInput revisionDataInput) throws IOException {
            Map map = revisionDataInput.readMap(DataInput::readDouble, DataInput::readDouble);
            Optional keyOpt = map.keySet().stream().findFirst();
            Optional value = map.values().stream().findFirst();
            return keyOpt.map(key -> new AbstractMap.SimpleEntry<Double, Object>((Double)key, value.orElse(null))).orElse(null);
        }

        private void write00(EpochTransitionRecord epochTransitionRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(epochTransitionRecord.getActiveEpoch());
            revisionDataOutput.writeLong(epochTransitionRecord.getTime());
            revisionDataOutput.writeCollection(epochTransitionRecord.getSegmentsToSeal(), DataOutput::writeLong);
            revisionDataOutput.writeMap(epochTransitionRecord.getNewSegmentsWithRange(), DataOutput::writeLong, this::writeValue);
        }

        private void writeValue(RevisionDataOutput revisionDataOutput, Map.Entry<Double, Double> value) throws IOException {
            HashMap<Double, Double> map = new HashMap<Double, Double>();
            map.put(value.getKey(), value.getValue());
            revisionDataOutput.writeMap(map, DataOutput::writeDouble, DataOutput::writeDouble);
        }

        protected EpochTransitionRecordBuilder newBuilder() {
            return EpochTransitionRecord.builder();
        }
    }

    private static class EpochTransitionRecordBuilder
    implements ObjectBuilder<EpochTransitionRecord> {
        @SuppressFBWarnings(justification="generated code")
        private int activeEpoch;
        @SuppressFBWarnings(justification="generated code")
        private long time;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableSet<Long> segmentsToSeal;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableMap<Long, Map.Entry<Double, Double>> newSegmentsWithRange;

        @SuppressFBWarnings(justification="generated code")
        EpochTransitionRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public EpochTransitionRecordBuilder activeEpoch(int activeEpoch) {
            this.activeEpoch = activeEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EpochTransitionRecordBuilder time(long time) {
            this.time = time;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EpochTransitionRecordBuilder segmentsToSeal(@NonNull ImmutableSet<Long> segmentsToSeal) {
            if (segmentsToSeal == null) {
                throw new NullPointerException("segmentsToSeal is marked @NonNull but is null");
            }
            this.segmentsToSeal = segmentsToSeal;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EpochTransitionRecordBuilder newSegmentsWithRange(@NonNull ImmutableMap<Long, Map.Entry<Double, Double>> newSegmentsWithRange) {
            if (newSegmentsWithRange == null) {
                throw new NullPointerException("newSegmentsWithRange is marked @NonNull but is null");
            }
            this.newSegmentsWithRange = newSegmentsWithRange;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public EpochTransitionRecord build() {
            return new EpochTransitionRecord(this.activeEpoch, this.time, this.segmentsToSeal, this.newSegmentsWithRange);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "EpochTransitionRecord.EpochTransitionRecordBuilder(activeEpoch=" + this.activeEpoch + ", time=" + this.time + ", segmentsToSeal=" + this.segmentsToSeal + ", newSegmentsWithRange=" + this.newSegmentsWithRange + ")";
        }
    }
}

