/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.pravega.common.Exceptions;
import io.pravega.controller.store.stream.records.EpochRecord;
import io.pravega.controller.store.stream.records.EpochTransitionRecord;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class RecordHelper {
    public static boolean validateInputRange(List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, EpochRecord currentEpoch) {
        boolean newRangesCheck = newRanges.stream().noneMatch(x -> (Double)x.getKey() >= (Double)x.getValue() && (Double)x.getValue() > 0.0);
        if (newRangesCheck) {
            List<Map.Entry<Double, Double>> oldRanges = segmentsToSeal.stream().map(segmentId -> {
                StreamSegmentRecord segment = currentEpoch.getSegment((long)segmentId);
                if (segment != null) {
                    return new AbstractMap.SimpleEntry<Double, Double>(segment.getKeyStart(), segment.getKeyEnd());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return RecordHelper.reduce(oldRanges).equals(RecordHelper.reduce(newRanges));
        }
        return false;
    }

    public static boolean canScaleFor(List<Long> segmentsToSeal, EpochRecord currentEpoch) {
        return segmentsToSeal.stream().allMatch(x -> currentEpoch.getSegment((long)x) != null);
    }

    public static boolean verifyRecordMatchesInput(List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, boolean isManualScale, EpochTransitionRecord record) {
        boolean newRangeMatch = newRanges.stream().allMatch(x -> record.getNewSegmentsWithRange().values().stream().anyMatch(y -> ((Double)y.getKey()).equals(x.getKey()) && ((Double)y.getValue()).equals(x.getValue())));
        if (newRangeMatch) {
            Set segmentNumbersToSeal = isManualScale ? segmentsToSeal.stream().map(StreamSegmentNameUtils::getSegmentNumber).collect(Collectors.toSet()) : null;
            return segmentsToSeal.stream().allMatch(segmentId -> {
                if (isManualScale) {
                    return segmentNumbersToSeal.contains(StreamSegmentNameUtils.getSegmentNumber((long)segmentId));
                }
                return record.getSegmentsToSeal().contains(segmentId);
            });
        }
        return false;
    }

    public static EpochTransitionRecord computeEpochTransition(EpochRecord currentEpoch, List<Long> segmentsToSeal, List<Map.Entry<Double, Double>> newRanges, long scaleTimestamp) {
        Preconditions.checkState((boolean)segmentsToSeal.stream().allMatch(currentEpoch::containsSegment), (Object)"Invalid epoch transition request");
        int newEpoch = currentEpoch.getEpoch() + 1;
        int nextSegmentNumber = currentEpoch.getSegments().stream().mapToInt(StreamSegmentRecord::getSegmentNumber).max().getAsInt() + 1;
        ImmutableMap.Builder newSegments = ImmutableMap.builder();
        for (int i = 0; i < newRanges.size(); ++i) {
            newSegments.put((Object)StreamSegmentNameUtils.computeSegmentId((int)(nextSegmentNumber + i), (int)newEpoch), newRanges.get(i));
        }
        return new EpochTransitionRecord(currentEpoch.getEpoch(), scaleTimestamp, (ImmutableSet<Long>)ImmutableSet.copyOf(segmentsToSeal), (ImmutableMap<Long, Map.Entry<Double, Double>>)newSegments.build());
    }

    public static UUID generateTxnId(int epoch, int msb, long lsb) {
        long msb64Bit = (long)epoch << 32 | (long)msb & 0xFFFFFFFFL;
        return new UUID(msb64Bit, lsb);
    }

    public static int getTransactionEpoch(UUID txId) {
        return (int)(txId.getMostSignificantBits() >> 32);
    }

    public static long generalizedSegmentId(long segmentId, UUID txId) {
        return StreamSegmentNameUtils.computeSegmentId((int)StreamSegmentNameUtils.getSegmentNumber((long)segmentId), (int)RecordHelper.getTransactionEpoch(txId));
    }

    public static void validateStreamCut(List<Map.Entry<Double, Double>> streamCutSegments) {
        List<Map.Entry<Double, Double>> reduced = RecordHelper.reduce(streamCutSegments);
        Exceptions.checkArgument((reduced.size() == 1 && reduced.get(0).getKey().equals(0.0) && reduced.get(0).getValue().equals(1.0) ? 1 : 0) != 0, (String)"streamCut", (String)" Invalid input, Stream Cut does not cover full key range.", (Object[])new Object[0]);
    }

    public static boolean streamCutComparator(Map<Long, Long> streamCut1, Map<StreamSegmentRecord, Integer> span1, Map<Long, Long> streamCut2, Map<StreamSegmentRecord, Integer> span2) {
        return span1.entrySet().stream().allMatch(e1 -> span2.entrySet().stream().noneMatch(e2 -> ((StreamSegmentRecord)e2.getKey()).segmentId() == ((StreamSegmentRecord)e1.getKey()).segmentId() && (Long)streamCut1.get(((StreamSegmentRecord)e1.getKey()).segmentId()) < (Long)streamCut2.get(((StreamSegmentRecord)e2.getKey()).segmentId()) || ((StreamSegmentRecord)e2.getKey()).overlaps((StreamSegmentRecord)e1.getKey()) && (Integer)e1.getValue() < (Integer)e2.getValue()));
    }

    private static List<Map.Entry<Double, Double>> reduce(List<Map.Entry<Double, Double>> input) {
        ArrayList<Map.Entry<Double, Double>> ranges = new ArrayList<Map.Entry<Double, Double>>(input);
        ranges.sort(Comparator.comparingDouble(Map.Entry::getKey));
        ArrayList<Map.Entry<Double, Double>> result = new ArrayList<Map.Entry<Double, Double>>();
        double low = -1.0;
        double high = -1.0;
        for (Map.Entry entry : ranges) {
            if (high < (Double)entry.getKey()) {
                if (low != -1.0 && high != -1.0) {
                    result.add(new AbstractMap.SimpleEntry<Double, Double>(low, high));
                }
                low = (Double)entry.getKey();
                high = (Double)entry.getValue();
                continue;
            }
            if (high == (Double)entry.getKey()) {
                high = (Double)entry.getValue();
                continue;
            }
            assert (low >= 0.0);
            assert (high > 0.0);
            result.add(new AbstractMap.SimpleEntry<Double, Double>(low, high));
            low = (Double)entry.getKey();
            high = (Double)entry.getValue();
        }
        if (low != -1.0 && high != -1.0) {
            result.add(new AbstractMap.SimpleEntry<Double, Double>(low, high));
        }
        return result;
    }
}

