/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.CollectionHelpers;
import io.pravega.controller.store.stream.records.StreamCutRecord;
import io.pravega.controller.store.stream.records.StreamCutReferenceRecord;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetentionSet {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(RetentionSet.class);
    public static final RetentionSetSerializer SERIALIZER = new RetentionSetSerializer();
    private final ImmutableList<StreamCutReferenceRecord> retentionRecords;

    public RetentionSet(@NonNull ImmutableList<StreamCutReferenceRecord> retentionRecords) {
        if (retentionRecords == null) {
            throw new NullPointerException("retentionRecords is marked @NonNull but is null");
        }
        this.retentionRecords = retentionRecords;
    }

    public static RetentionSet addReferenceToStreamCutIfLatest(RetentionSet retentionSet, StreamCutRecord cut) {
        ImmutableList<StreamCutReferenceRecord> retentionRecords = retentionSet.retentionRecords;
        if (retentionRecords.isEmpty() || ((StreamCutReferenceRecord)retentionRecords.get(retentionRecords.size() - 1)).getRecordingTime() < cut.getRecordingTime()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(retentionRecords);
            builder.add((Object)new StreamCutReferenceRecord(cut.getRecordingTime(), cut.getRecordingSize()));
            return new RetentionSet((ImmutableList<StreamCutReferenceRecord>)builder.build());
        }
        return retentionSet;
    }

    public StreamCutReferenceRecord findStreamCutReferenceForTime(long time) {
        int beforeIndex = RetentionSet.getGreatestLowerBound(this, time, StreamCutReferenceRecord::getRecordingTime);
        if (beforeIndex < 0) {
            return null;
        }
        return (StreamCutReferenceRecord)this.retentionRecords.get(beforeIndex);
    }

    public StreamCutReferenceRecord findStreamCutReferenceForSize(long size) {
        int beforeIndex = RetentionSet.getGreatestLowerBound(this, size, StreamCutReferenceRecord::getRecordingSize);
        if (beforeIndex < 0) {
            return null;
        }
        return (StreamCutReferenceRecord)this.retentionRecords.get(beforeIndex);
    }

    public List<StreamCutReferenceRecord> retentionRecordsBefore(StreamCutReferenceRecord record) {
        Preconditions.checkNotNull((Object)record);
        int beforeIndex = RetentionSet.getGreatestLowerBound(this, record.getRecordingTime(), StreamCutReferenceRecord::getRecordingTime);
        return this.retentionRecords.subList(0, beforeIndex + 1);
    }

    public static RetentionSet removeStreamCutBefore(RetentionSet set, StreamCutReferenceRecord record) {
        Preconditions.checkNotNull((Object)record);
        int beforeIndex = RetentionSet.getGreatestLowerBound(set, record.getRecordingTime(), StreamCutReferenceRecord::getRecordingTime);
        if (beforeIndex < 0) {
            return set;
        }
        if (beforeIndex + 1 == set.retentionRecords.size()) {
            return new RetentionSet((ImmutableList<StreamCutReferenceRecord>)ImmutableList.of());
        }
        return new RetentionSet((ImmutableList<StreamCutReferenceRecord>)set.retentionRecords.subList(beforeIndex + 1, set.retentionRecords.size()));
    }

    private static int getGreatestLowerBound(RetentionSet set, long value, Function<StreamCutReferenceRecord, Long> func) {
        return CollectionHelpers.findGreatestLowerBound(set.retentionRecords, x -> Long.compare(value, (Long)func.apply((StreamCutReferenceRecord)x)));
    }

    public StreamCutReferenceRecord getLatest() {
        if (this.retentionRecords.isEmpty()) {
            return null;
        }
        return (StreamCutReferenceRecord)this.retentionRecords.get(this.retentionRecords.size() - 1);
    }

    public static RetentionSet fromBytes(byte[] data) {
        return (RetentionSet)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static RetentionSetBuilder builder() {
        return new RetentionSetBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableList<StreamCutReferenceRecord> getRetentionRecords() {
        return this.retentionRecords;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetentionSet)) {
            return false;
        }
        RetentionSet other = (RetentionSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<StreamCutReferenceRecord> this$retentionRecords = this.getRetentionRecords();
        ImmutableList<StreamCutReferenceRecord> other$retentionRecords = other.getRetentionRecords();
        return !(this$retentionRecords == null ? other$retentionRecords != null : !this$retentionRecords.equals(other$retentionRecords));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof RetentionSet;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<StreamCutReferenceRecord> $retentionRecords = this.getRetentionRecords();
        result = result * 59 + ($retentionRecords == null ? 43 : $retentionRecords.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "RetentionSet(retentionRecords=" + this.getRetentionRecords() + ")";
    }

    private static class RetentionSetSerializer
    extends VersionedSerializer.WithBuilder<RetentionSet, RetentionSetBuilder> {
        private RetentionSetSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, RetentionSetBuilder retentionRecordBuilder) throws IOException {
            ImmutableList.Builder builder = ImmutableList.builder();
            revisionDataInput.readCollection(arg_0 -> ((StreamCutReferenceRecord.StreamCutReferenceRecordSerializer)StreamCutReferenceRecord.SERIALIZER).deserialize(arg_0), (ImmutableCollection.Builder)builder);
            retentionRecordBuilder.retentionRecords((ImmutableList<StreamCutReferenceRecord>)builder.build());
        }

        private void write00(RetentionSet retentionRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeCollection(retentionRecord.getRetentionRecords(), (arg_0, arg_1) -> ((StreamCutReferenceRecord.StreamCutReferenceRecordSerializer)StreamCutReferenceRecord.SERIALIZER).serialize(arg_0, arg_1));
        }

        protected RetentionSetBuilder newBuilder() {
            return RetentionSet.builder();
        }
    }

    private static class RetentionSetBuilder
    implements ObjectBuilder<RetentionSet> {
        @SuppressFBWarnings(justification="generated code")
        private ImmutableList<StreamCutReferenceRecord> retentionRecords;

        @SuppressFBWarnings(justification="generated code")
        RetentionSetBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public RetentionSetBuilder retentionRecords(@NonNull ImmutableList<StreamCutReferenceRecord> retentionRecords) {
            if (retentionRecords == null) {
                throw new NullPointerException("retentionRecords is marked @NonNull but is null");
            }
            this.retentionRecords = retentionRecords;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public RetentionSet build() {
            return new RetentionSet(this.retentionRecords);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "RetentionSet.RetentionSetBuilder(retentionRecords=" + this.retentionRecords + ")";
        }
    }
}

