/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SealedSegmentsMapShard {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(SealedSegmentsMapShard.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    public static final SealedSegmentsMapShardSerializer SERIALIZER = new SealedSegmentsMapShardSerializer();
    public static final int SHARD_SIZE = 1000;
    private final int shardNumber;
    private final Map<Long, Long> sealedSegmentsSizeMap;

    SealedSegmentsMapShard(int shardNumber, Map<Long, Long> sealedSegmentsSizeMap) {
        this.shardNumber = shardNumber;
        this.sealedSegmentsSizeMap = new HashMap<Long, Long>(sealedSegmentsSizeMap);
    }

    public static SealedSegmentsMapShard fromBytes(byte[] data) {
        return (SealedSegmentsMapShard)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSize(long segmentId) {
        Object object = this.$lock;
        synchronized (object) {
            return this.sealedSegmentsSizeMap.getOrDefault(segmentId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSealedSegmentSize(long segmentId, long sealedSize) {
        Object object = this.$lock;
        synchronized (object) {
            this.sealedSegmentsSizeMap.putIfAbsent(segmentId, sealedSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Long> getSealedSegmentsSizeMap() {
        Object object = this.$lock;
        synchronized (object) {
            return Collections.unmodifiableMap(this.sealedSegmentsSizeMap);
        }
    }

    public static int getShardNumber(long segmentId, int shardChunkSize) {
        return StreamSegmentNameUtils.getEpoch((long)segmentId) / shardChunkSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public static SealedSegmentsMapShardBuilder builder() {
        return new SealedSegmentsMapShardBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getShardNumber() {
        return this.shardNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SealedSegmentsMapShard)) {
            return false;
        }
        SealedSegmentsMapShard other = (SealedSegmentsMapShard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getShardNumber() != other.getShardNumber()) {
            return false;
        }
        Map<Long, Long> this$sealedSegmentsSizeMap = this.getSealedSegmentsSizeMap();
        Map<Long, Long> other$sealedSegmentsSizeMap = other.getSealedSegmentsSizeMap();
        return !(this$sealedSegmentsSizeMap == null ? other$sealedSegmentsSizeMap != null : !((Object)this$sealedSegmentsSizeMap).equals(other$sealedSegmentsSizeMap));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof SealedSegmentsMapShard;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getShardNumber();
        Map<Long, Long> $sealedSegmentsSizeMap = this.getSealedSegmentsSizeMap();
        result = result * 59 + ($sealedSegmentsSizeMap == null ? 43 : ((Object)$sealedSegmentsSizeMap).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "SealedSegmentsMapShard(shardNumber=" + this.getShardNumber() + ", sealedSegmentsSizeMap=" + this.getSealedSegmentsSizeMap() + ")";
    }

    private static class SealedSegmentsMapShardSerializer
    extends VersionedSerializer.WithBuilder<SealedSegmentsMapShard, SealedSegmentsMapShardBuilder> {
        private SealedSegmentsMapShardSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, SealedSegmentsMapShardBuilder sealedSegmentsRecordBuilder) throws IOException {
            sealedSegmentsRecordBuilder.sealedSegmentsSizeMap(revisionDataInput.readMap(DataInput::readLong, DataInput::readLong));
        }

        private void write00(SealedSegmentsMapShard sealedSegmentsRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(sealedSegmentsRecord.getSealedSegmentsSizeMap(), DataOutput::writeLong, DataOutput::writeLong);
        }

        protected SealedSegmentsMapShardBuilder newBuilder() {
            return SealedSegmentsMapShard.builder();
        }
    }

    public static class SealedSegmentsMapShardBuilder
    implements ObjectBuilder<SealedSegmentsMapShard> {
        @SuppressFBWarnings(justification="generated code")
        private int shardNumber;
        @SuppressFBWarnings(justification="generated code")
        private Map<Long, Long> sealedSegmentsSizeMap;

        @SuppressFBWarnings(justification="generated code")
        SealedSegmentsMapShardBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public SealedSegmentsMapShardBuilder shardNumber(int shardNumber) {
            this.shardNumber = shardNumber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public SealedSegmentsMapShardBuilder sealedSegmentsSizeMap(Map<Long, Long> sealedSegmentsSizeMap) {
            this.sealedSegmentsSizeMap = sealedSegmentsSizeMap;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public SealedSegmentsMapShard build() {
            return new SealedSegmentsMapShard(this.shardNumber, this.sealedSegmentsSizeMap);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "SealedSegmentsMapShard.SealedSegmentsMapShardBuilder(shardNumber=" + this.shardNumber + ", sealedSegmentsSizeMap=" + this.sealedSegmentsSizeMap + ")";
        }
    }
}

