/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfigurationRecord {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamConfigurationRecord.class);
    public static final ConfigurationRecordSerializer SERIALIZER = new ConfigurationRecordSerializer();
    @NonNull
    private final String scope;
    @NonNull
    private final String streamName;
    private final StreamConfiguration streamConfiguration;
    private final boolean updating;

    public static StreamConfigurationRecord update(String scope, String streamName, StreamConfiguration streamConfig) {
        return StreamConfigurationRecord.builder().scope(scope).streamName(streamName).streamConfiguration(streamConfig).updating(true).build();
    }

    public static StreamConfigurationRecord complete(String scope, String streamName, StreamConfiguration streamConfig) {
        return StreamConfigurationRecord.builder().scope(scope).streamName(streamName).streamConfiguration(streamConfig).updating(false).build();
    }

    public static StreamConfigurationRecord fromBytes(byte[] data) {
        return (StreamConfigurationRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamConfigurationRecordBuilder builder() {
        return new StreamConfigurationRecordBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public String getScope() {
        return this.scope;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    public String getStreamName() {
        return this.streamName;
    }

    @SuppressFBWarnings(justification="generated code")
    public StreamConfiguration getStreamConfiguration() {
        return this.streamConfiguration;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUpdating() {
        return this.updating;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamConfigurationRecord)) {
            return false;
        }
        StreamConfigurationRecord other = (StreamConfigurationRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$streamName = this.getStreamName();
        String other$streamName = other.getStreamName();
        if (this$streamName == null ? other$streamName != null : !this$streamName.equals(other$streamName)) {
            return false;
        }
        StreamConfiguration this$streamConfiguration = this.getStreamConfiguration();
        StreamConfiguration other$streamConfiguration = other.getStreamConfiguration();
        if (this$streamConfiguration == null ? other$streamConfiguration != null : !this$streamConfiguration.equals(other$streamConfiguration)) {
            return false;
        }
        return this.isUpdating() == other.isUpdating();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamConfigurationRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $streamName = this.getStreamName();
        result = result * 59 + ($streamName == null ? 43 : $streamName.hashCode());
        StreamConfiguration $streamConfiguration = this.getStreamConfiguration();
        result = result * 59 + ($streamConfiguration == null ? 43 : $streamConfiguration.hashCode());
        result = result * 59 + (this.isUpdating() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StreamConfigurationRecord(scope=" + this.getScope() + ", streamName=" + this.getStreamName() + ", streamConfiguration=" + this.getStreamConfiguration() + ", updating=" + this.isUpdating() + ")";
    }

    @ConstructorProperties(value={"scope", "streamName", "streamConfiguration", "updating"})
    @SuppressFBWarnings(justification="generated code")
    public StreamConfigurationRecord(@NonNull String scope, @NonNull String streamName, StreamConfiguration streamConfiguration, boolean updating) {
        if (scope == null) {
            throw new NullPointerException("scope is marked @NonNull but is null");
        }
        if (streamName == null) {
            throw new NullPointerException("streamName is marked @NonNull but is null");
        }
        this.scope = scope;
        this.streamName = streamName;
        this.streamConfiguration = streamConfiguration;
        this.updating = updating;
    }

    private static class ConfigurationRecordSerializer
    extends VersionedSerializer.WithBuilder<StreamConfigurationRecord, StreamConfigurationRecordBuilder> {
        private ConfigurationRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        protected void beforeSerialization(StreamConfigurationRecord streamConfigurationRecord) {
            Preconditions.checkNotNull((Object)streamConfigurationRecord);
            Preconditions.checkNotNull((Object)streamConfigurationRecord.getStreamConfiguration());
        }

        private void read00(RevisionDataInput revisionDataInput, StreamConfigurationRecordBuilder configurationRecordBuilder) throws IOException {
            configurationRecordBuilder.scope(revisionDataInput.readUTF()).streamName(revisionDataInput.readUTF());
            StreamConfiguration.StreamConfigurationBuilder streamConfigurationBuilder = StreamConfiguration.builder();
            streamConfigurationBuilder.scalingPolicy(((ScalingPolicyRecord)ScalingPolicyRecord.SERIALIZER.deserialize(revisionDataInput)).getScalingPolicy()).retentionPolicy(((RetentionPolicyRecord)RetentionPolicyRecord.SERIALIZER.deserialize(revisionDataInput)).getRetentionPolicy());
            configurationRecordBuilder.streamConfiguration(streamConfigurationBuilder.build()).updating(revisionDataInput.readBoolean());
        }

        private void write00(StreamConfigurationRecord streamConfigurationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(streamConfigurationRecord.getScope());
            revisionDataOutput.writeUTF(streamConfigurationRecord.getStreamName());
            ScalingPolicyRecord.SERIALIZER.serialize(revisionDataOutput, new ScalingPolicyRecord(streamConfigurationRecord.getStreamConfiguration().getScalingPolicy()));
            RetentionPolicyRecord.SERIALIZER.serialize(revisionDataOutput, new RetentionPolicyRecord(streamConfigurationRecord.getStreamConfiguration().getRetentionPolicy()));
            revisionDataOutput.writeBoolean(streamConfigurationRecord.isUpdating());
        }

        private void read01(RevisionDataInput revisionDataInput, StreamConfigurationRecordBuilder configurationRecordBuilder) throws IOException {
            StreamConfiguration.StreamConfigurationBuilder streamConfigurationBuilder = StreamConfiguration.builder();
            streamConfigurationBuilder.scalingPolicy(configurationRecordBuilder.streamConfiguration.getScalingPolicy()).retentionPolicy(configurationRecordBuilder.streamConfiguration.getRetentionPolicy()).timestampAggregationTimeout(revisionDataInput.readLong());
            configurationRecordBuilder.streamConfiguration(streamConfigurationBuilder.build());
        }

        private void write01(StreamConfigurationRecord streamConfigurationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(streamConfigurationRecord.streamConfiguration.getTimestampAggregationTimeout());
        }

        protected StreamConfigurationRecordBuilder newBuilder() {
            return StreamConfigurationRecord.builder();
        }
    }

    public static class RetentionPolicyRecord {
        @SuppressFBWarnings(justification="generated code")
        private static final Logger log = LoggerFactory.getLogger(RetentionPolicyRecord.class);
        public static final RetentionPolicyRecordSerializer SERIALIZER = new RetentionPolicyRecordSerializer();
        private final RetentionPolicy retentionPolicy;

        @SuppressFBWarnings(justification="generated code")
        public static RetentionPolicyRecordBuilder builder() {
            return new RetentionPolicyRecordBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public RetentionPolicy getRetentionPolicy() {
            return this.retentionPolicy;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetentionPolicyRecord)) {
                return false;
            }
            RetentionPolicyRecord other = (RetentionPolicyRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RetentionPolicy this$retentionPolicy = this.getRetentionPolicy();
            RetentionPolicy other$retentionPolicy = other.getRetentionPolicy();
            return !(this$retentionPolicy == null ? other$retentionPolicy != null : !this$retentionPolicy.equals(other$retentionPolicy));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof RetentionPolicyRecord;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RetentionPolicy $retentionPolicy = this.getRetentionPolicy();
            result = result * 59 + ($retentionPolicy == null ? 43 : $retentionPolicy.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamConfigurationRecord.RetentionPolicyRecord(retentionPolicy=" + this.getRetentionPolicy() + ")";
        }

        @ConstructorProperties(value={"retentionPolicy"})
        @SuppressFBWarnings(justification="generated code")
        public RetentionPolicyRecord(RetentionPolicy retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
        }

        private static class RetentionPolicyRecordSerializer
        extends VersionedSerializer.WithBuilder<RetentionPolicyRecord, RetentionPolicyRecordBuilder> {
            private RetentionPolicyRecordSerializer() {
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput revisionDataInput, RetentionPolicyRecordBuilder retentionPolicyRecordBuilder) throws IOException {
                boolean exists = revisionDataInput.readBoolean();
                if (exists) {
                    retentionPolicyRecordBuilder.retentionPolicy(RetentionPolicy.builder().retentionType(RetentionPolicy.RetentionType.values()[revisionDataInput.readCompactInt()]).retentionParam(revisionDataInput.readLong()).build());
                } else {
                    retentionPolicyRecordBuilder.retentionPolicy(null);
                }
            }

            private void write00(RetentionPolicyRecord retentionPolicyRecord, RevisionDataOutput revisionDataOutput) throws IOException {
                if (retentionPolicyRecord == null || retentionPolicyRecord.getRetentionPolicy() == null) {
                    revisionDataOutput.writeBoolean(false);
                } else {
                    revisionDataOutput.writeBoolean(true);
                    RetentionPolicy retentionPolicy = retentionPolicyRecord.getRetentionPolicy();
                    revisionDataOutput.writeCompactInt(retentionPolicy.getRetentionType().ordinal());
                    revisionDataOutput.writeLong(retentionPolicy.getRetentionParam());
                }
            }

            protected RetentionPolicyRecordBuilder newBuilder() {
                return RetentionPolicyRecord.builder();
            }
        }

        public static class RetentionPolicyRecordBuilder
        implements ObjectBuilder<RetentionPolicyRecord> {
            @SuppressFBWarnings(justification="generated code")
            private RetentionPolicy retentionPolicy;

            @SuppressFBWarnings(justification="generated code")
            RetentionPolicyRecordBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public RetentionPolicyRecordBuilder retentionPolicy(RetentionPolicy retentionPolicy) {
                this.retentionPolicy = retentionPolicy;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public RetentionPolicyRecord build() {
                return new RetentionPolicyRecord(this.retentionPolicy);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "StreamConfigurationRecord.RetentionPolicyRecord.RetentionPolicyRecordBuilder(retentionPolicy=" + this.retentionPolicy + ")";
            }
        }
    }

    public static class ScalingPolicyRecord {
        @SuppressFBWarnings(justification="generated code")
        private static final Logger log = LoggerFactory.getLogger(ScalingPolicyRecord.class);
        public static final ScalingPolicyRecordSerializer SERIALIZER = new ScalingPolicyRecordSerializer();
        private final ScalingPolicy scalingPolicy;

        @SuppressFBWarnings(justification="generated code")
        public static ScalingPolicyRecordBuilder builder() {
            return new ScalingPolicyRecordBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public ScalingPolicy getScalingPolicy() {
            return this.scalingPolicy;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScalingPolicyRecord)) {
                return false;
            }
            ScalingPolicyRecord other = (ScalingPolicyRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ScalingPolicy this$scalingPolicy = this.getScalingPolicy();
            ScalingPolicy other$scalingPolicy = other.getScalingPolicy();
            return !(this$scalingPolicy == null ? other$scalingPolicy != null : !this$scalingPolicy.equals(other$scalingPolicy));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ScalingPolicyRecord;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScalingPolicy $scalingPolicy = this.getScalingPolicy();
            result = result * 59 + ($scalingPolicy == null ? 43 : $scalingPolicy.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamConfigurationRecord.ScalingPolicyRecord(scalingPolicy=" + this.getScalingPolicy() + ")";
        }

        @ConstructorProperties(value={"scalingPolicy"})
        @SuppressFBWarnings(justification="generated code")
        public ScalingPolicyRecord(ScalingPolicy scalingPolicy) {
            this.scalingPolicy = scalingPolicy;
        }

        private static class ScalingPolicyRecordSerializer
        extends VersionedSerializer.WithBuilder<ScalingPolicyRecord, ScalingPolicyRecordBuilder> {
            private ScalingPolicyRecordSerializer() {
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput revisionDataInput, ScalingPolicyRecordBuilder scalingPolicyRecordBuilder) throws IOException {
                boolean exists = revisionDataInput.readBoolean();
                if (exists) {
                    int ordinal = revisionDataInput.readCompactInt();
                    scalingPolicyRecordBuilder.scalingPolicy(ScalingPolicy.builder().scaleType(ScalingPolicy.ScaleType.values()[ordinal]).targetRate(revisionDataInput.readInt()).scaleFactor(revisionDataInput.readInt()).minNumSegments(revisionDataInput.readInt()).build());
                } else {
                    scalingPolicyRecordBuilder.scalingPolicy(null);
                }
            }

            private void write00(ScalingPolicyRecord scalingPolicyRecord, RevisionDataOutput revisionDataOutput) throws IOException {
                if (scalingPolicyRecord == null || scalingPolicyRecord.getScalingPolicy() == null) {
                    revisionDataOutput.writeBoolean(false);
                } else {
                    revisionDataOutput.writeBoolean(true);
                    ScalingPolicy scalingPolicy = scalingPolicyRecord.getScalingPolicy();
                    revisionDataOutput.writeCompactInt(scalingPolicy.getScaleType().ordinal());
                    revisionDataOutput.writeInt(scalingPolicy.getTargetRate());
                    revisionDataOutput.writeInt(scalingPolicy.getScaleFactor());
                    revisionDataOutput.writeInt(scalingPolicy.getMinNumSegments());
                }
            }

            protected ScalingPolicyRecordBuilder newBuilder() {
                return ScalingPolicyRecord.builder();
            }
        }

        public static class ScalingPolicyRecordBuilder
        implements ObjectBuilder<ScalingPolicyRecord> {
            @SuppressFBWarnings(justification="generated code")
            private ScalingPolicy scalingPolicy;

            @SuppressFBWarnings(justification="generated code")
            ScalingPolicyRecordBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public ScalingPolicyRecordBuilder scalingPolicy(ScalingPolicy scalingPolicy) {
                this.scalingPolicy = scalingPolicy;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ScalingPolicyRecord build() {
                return new ScalingPolicyRecord(this.scalingPolicy);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "StreamConfigurationRecord.ScalingPolicyRecord.ScalingPolicyRecordBuilder(scalingPolicy=" + this.scalingPolicy + ")";
            }
        }
    }

    public static class StreamConfigurationRecordBuilder
    implements ObjectBuilder<StreamConfigurationRecord> {
        @SuppressFBWarnings(justification="generated code")
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        private String streamName;
        @SuppressFBWarnings(justification="generated code")
        private StreamConfiguration streamConfiguration;
        @SuppressFBWarnings(justification="generated code")
        private boolean updating;

        @SuppressFBWarnings(justification="generated code")
        StreamConfigurationRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationRecordBuilder scope(@NonNull String scope) {
            if (scope == null) {
                throw new NullPointerException("scope is marked @NonNull but is null");
            }
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationRecordBuilder streamName(@NonNull String streamName) {
            if (streamName == null) {
                throw new NullPointerException("streamName is marked @NonNull but is null");
            }
            this.streamName = streamName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationRecordBuilder streamConfiguration(StreamConfiguration streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationRecordBuilder updating(boolean updating) {
            this.updating = updating;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamConfigurationRecord build() {
            return new StreamConfigurationRecord(this.scope, this.streamName, this.streamConfiguration, this.updating);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamConfigurationRecord.StreamConfigurationRecordBuilder(scope=" + this.scope + ", streamName=" + this.streamName + ", streamConfiguration=" + this.streamConfiguration + ", updating=" + this.updating + ")";
        }
    }
}

