/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCutReferenceRecord {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamCutReferenceRecord.class);
    public static final StreamCutReferenceRecordSerializer SERIALIZER = new StreamCutReferenceRecordSerializer();
    final long recordingTime;
    final long recordingSize;

    public static StreamCutReferenceRecord fromBytes(byte[] data) {
        return (StreamCutReferenceRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamCutReferenceRecordBuilder builder() {
        return new StreamCutReferenceRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public long getRecordingTime() {
        return this.recordingTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getRecordingSize() {
        return this.recordingSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamCutReferenceRecord)) {
            return false;
        }
        StreamCutReferenceRecord other = (StreamCutReferenceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRecordingTime() != other.getRecordingTime()) {
            return false;
        }
        return this.getRecordingSize() == other.getRecordingSize();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamCutReferenceRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $recordingTime = this.getRecordingTime();
        result = result * 59 + (int)($recordingTime >>> 32 ^ $recordingTime);
        long $recordingSize = this.getRecordingSize();
        result = result * 59 + (int)($recordingSize >>> 32 ^ $recordingSize);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StreamCutReferenceRecord(recordingTime=" + this.getRecordingTime() + ", recordingSize=" + this.getRecordingSize() + ")";
    }

    @ConstructorProperties(value={"recordingTime", "recordingSize"})
    @SuppressFBWarnings(justification="generated code")
    public StreamCutReferenceRecord(long recordingTime, long recordingSize) {
        this.recordingTime = recordingTime;
        this.recordingSize = recordingSize;
    }

    static class StreamCutReferenceRecordSerializer
    extends VersionedSerializer.WithBuilder<StreamCutReferenceRecord, StreamCutReferenceRecordBuilder> {
        StreamCutReferenceRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamCutReferenceRecordBuilder retentionRecordBuilder) throws IOException {
            retentionRecordBuilder.recordingSize(revisionDataInput.readLong());
            retentionRecordBuilder.recordingTime(revisionDataInput.readLong());
        }

        private void write00(StreamCutReferenceRecord retentionRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(retentionRecord.getRecordingSize());
            revisionDataOutput.writeLong(retentionRecord.getRecordingTime());
        }

        protected StreamCutReferenceRecordBuilder newBuilder() {
            return StreamCutReferenceRecord.builder();
        }
    }

    public static class StreamCutReferenceRecordBuilder
    implements ObjectBuilder<StreamCutReferenceRecord> {
        @SuppressFBWarnings(justification="generated code")
        private long recordingTime;
        @SuppressFBWarnings(justification="generated code")
        private long recordingSize;

        @SuppressFBWarnings(justification="generated code")
        StreamCutReferenceRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamCutReferenceRecordBuilder recordingTime(long recordingTime) {
            this.recordingTime = recordingTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamCutReferenceRecordBuilder recordingSize(long recordingSize) {
            this.recordingSize = recordingSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamCutReferenceRecord build() {
            return new StreamCutReferenceRecord(this.recordingTime, this.recordingSize);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamCutReferenceRecord.StreamCutReferenceRecordBuilder(recordingTime=" + this.recordingTime + ", recordingSize=" + this.recordingSize + ")";
        }
    }
}

