/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;

public class StreamSegmentRecord {
    public static final StreamSegmentRecordSerializer SERIALIZER = new StreamSegmentRecordSerializer();
    private final int segmentNumber;
    private final int creationEpoch;
    private final long creationTime;
    private final double keyStart;
    private final double keyEnd;

    public long segmentId() {
        return StreamSegmentNameUtils.computeSegmentId((int)this.segmentNumber, (int)this.creationEpoch);
    }

    public boolean overlaps(StreamSegmentRecord segment) {
        return segment.getKeyStart() < this.keyEnd && segment.getKeyEnd() > this.keyStart;
    }

    public boolean overlaps(double keyStart, double keyEnd) {
        return keyEnd > this.keyStart && keyStart < this.keyEnd;
    }

    public static boolean overlaps(Map.Entry<Double, Double> first, Map.Entry<Double, Double> second) {
        return second.getValue() > first.getKey() && second.getKey() < first.getValue();
    }

    @VisibleForTesting
    public static StreamSegmentRecord newSegmentRecord(int num, int epoch, long time, double start, double end) {
        return StreamSegmentRecord.builder().segmentNumber(num).creationEpoch(epoch).creationTime(time).keyStart(start).keyEnd(end).build();
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamSegmentRecordBuilder builder() {
        return new StreamSegmentRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getCreationEpoch() {
        return this.creationEpoch;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getCreationTime() {
        return this.creationTime;
    }

    @SuppressFBWarnings(justification="generated code")
    public double getKeyStart() {
        return this.keyStart;
    }

    @SuppressFBWarnings(justification="generated code")
    public double getKeyEnd() {
        return this.keyEnd;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSegmentRecord)) {
            return false;
        }
        StreamSegmentRecord other = (StreamSegmentRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSegmentNumber() != other.getSegmentNumber()) {
            return false;
        }
        if (this.getCreationEpoch() != other.getCreationEpoch()) {
            return false;
        }
        if (this.getCreationTime() != other.getCreationTime()) {
            return false;
        }
        if (Double.compare(this.getKeyStart(), other.getKeyStart()) != 0) {
            return false;
        }
        return Double.compare(this.getKeyEnd(), other.getKeyEnd()) == 0;
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamSegmentRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSegmentNumber();
        result = result * 59 + this.getCreationEpoch();
        long $creationTime = this.getCreationTime();
        result = result * 59 + (int)($creationTime >>> 32 ^ $creationTime);
        long $keyStart = Double.doubleToLongBits(this.getKeyStart());
        result = result * 59 + (int)($keyStart >>> 32 ^ $keyStart);
        long $keyEnd = Double.doubleToLongBits(this.getKeyEnd());
        result = result * 59 + (int)($keyEnd >>> 32 ^ $keyEnd);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StreamSegmentRecord(segmentNumber=" + this.getSegmentNumber() + ", creationEpoch=" + this.getCreationEpoch() + ", creationTime=" + this.getCreationTime() + ", keyStart=" + this.getKeyStart() + ", keyEnd=" + this.getKeyEnd() + ")";
    }

    @ConstructorProperties(value={"segmentNumber", "creationEpoch", "creationTime", "keyStart", "keyEnd"})
    @SuppressFBWarnings(justification="generated code")
    public StreamSegmentRecord(int segmentNumber, int creationEpoch, long creationTime, double keyStart, double keyEnd) {
        this.segmentNumber = segmentNumber;
        this.creationEpoch = creationEpoch;
        this.creationTime = creationTime;
        this.keyStart = keyStart;
        this.keyEnd = keyEnd;
    }

    static class StreamSegmentRecordSerializer
    extends VersionedSerializer.WithBuilder<StreamSegmentRecord, StreamSegmentRecordBuilder> {
        StreamSegmentRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamSegmentRecordBuilder builder) throws IOException {
            builder.segmentNumber(revisionDataInput.readInt()).creationTime(revisionDataInput.readLong()).creationEpoch(revisionDataInput.readInt()).keyStart(Double.longBitsToDouble(revisionDataInput.readLong())).keyEnd(Double.longBitsToDouble(revisionDataInput.readLong()));
        }

        private void write00(StreamSegmentRecord segment, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(segment.getSegmentNumber());
            revisionDataOutput.writeLong(segment.getCreationTime());
            revisionDataOutput.writeInt(segment.getCreationEpoch());
            revisionDataOutput.writeLong(Double.doubleToRawLongBits(segment.getKeyStart()));
            revisionDataOutput.writeLong(Double.doubleToRawLongBits(segment.getKeyEnd()));
        }

        protected StreamSegmentRecordBuilder newBuilder() {
            return StreamSegmentRecord.builder();
        }
    }

    public static class StreamSegmentRecordBuilder
    implements ObjectBuilder<StreamSegmentRecord> {
        @SuppressFBWarnings(justification="generated code")
        private int segmentNumber;
        @SuppressFBWarnings(justification="generated code")
        private int creationEpoch;
        @SuppressFBWarnings(justification="generated code")
        private long creationTime;
        @SuppressFBWarnings(justification="generated code")
        private double keyStart;
        @SuppressFBWarnings(justification="generated code")
        private double keyEnd;

        @SuppressFBWarnings(justification="generated code")
        StreamSegmentRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecordBuilder segmentNumber(int segmentNumber) {
            this.segmentNumber = segmentNumber;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecordBuilder creationEpoch(int creationEpoch) {
            this.creationEpoch = creationEpoch;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecordBuilder creationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecordBuilder keyStart(double keyStart) {
            this.keyStart = keyStart;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecordBuilder keyEnd(double keyEnd) {
            this.keyEnd = keyEnd;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamSegmentRecord build() {
            return new StreamSegmentRecord(this.segmentNumber, this.creationEpoch, this.creationTime, this.keyStart, this.keyEnd);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamSegmentRecord.StreamSegmentRecordBuilder(segmentNumber=" + this.segmentNumber + ", creationEpoch=" + this.creationEpoch + ", creationTime=" + this.creationTime + ", keyStart=" + this.keyStart + ", keyEnd=" + this.keyEnd + ")";
        }
    }
}

