/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.controller.store.stream.records.StreamSegmentRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTruncationRecord {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamTruncationRecord.class);
    public static final TruncationRecordSerializer SERIALIZER = new TruncationRecordSerializer();
    public static final StreamTruncationRecord EMPTY = new StreamTruncationRecord((ImmutableMap<Long, Long>)ImmutableMap.of(), (ImmutableMap<StreamSegmentRecord, Integer>)ImmutableMap.of(), (ImmutableSet<Long>)ImmutableSet.of(), (ImmutableSet<Long>)ImmutableSet.of(), 0L, false);
    private final ImmutableMap<Long, Long> streamCut;
    private final ImmutableMap<StreamSegmentRecord, Integer> span;
    private final int spanEpochLow;
    private final int spanEpochHigh;
    private final ImmutableSet<Long> deletedSegments;
    private final ImmutableSet<Long> toDelete;
    private final long sizeTill;
    private final boolean updating;

    public StreamTruncationRecord(@NonNull ImmutableMap<Long, Long> streamCut, @NonNull ImmutableMap<StreamSegmentRecord, Integer> span, @NonNull ImmutableSet<Long> deletedSegments, @NonNull ImmutableSet<Long> toDelete, long sizeTill, boolean updating) {
        if (streamCut == null) {
            throw new NullPointerException("streamCut is marked @NonNull but is null");
        }
        if (span == null) {
            throw new NullPointerException("span is marked @NonNull but is null");
        }
        if (deletedSegments == null) {
            throw new NullPointerException("deletedSegments is marked @NonNull but is null");
        }
        if (toDelete == null) {
            throw new NullPointerException("toDelete is marked @NonNull but is null");
        }
        this.streamCut = streamCut;
        this.span = span;
        this.deletedSegments = deletedSegments;
        this.toDelete = toDelete;
        this.sizeTill = sizeTill;
        this.updating = updating;
        this.spanEpochLow = span.values().stream().min(Comparator.naturalOrder()).orElse(Integer.MIN_VALUE);
        this.spanEpochHigh = span.values().stream().max(Comparator.naturalOrder()).orElse(Integer.MIN_VALUE);
    }

    public static StreamTruncationRecord complete(StreamTruncationRecord toComplete) {
        Preconditions.checkState((boolean)toComplete.updating);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(toComplete.deletedSegments);
        builder.addAll(toComplete.toDelete);
        return StreamTruncationRecord.builder().updating(false).span(toComplete.span).streamCut(toComplete.streamCut).deletedSegments((ImmutableSet<Long>)builder.build()).toDelete((ImmutableSet<Long>)ImmutableSet.of()).sizeTill(toComplete.sizeTill).build();
    }

    public static StreamTruncationRecord fromBytes(byte[] data) {
        return (StreamTruncationRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static StreamTruncationRecordBuilder builder() {
        return new StreamTruncationRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<Long, Long> getStreamCut() {
        return this.streamCut;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<StreamSegmentRecord, Integer> getSpan() {
        return this.span;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSpanEpochLow() {
        return this.spanEpochLow;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getSpanEpochHigh() {
        return this.spanEpochHigh;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<Long> getDeletedSegments() {
        return this.deletedSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableSet<Long> getToDelete() {
        return this.toDelete;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getSizeTill() {
        return this.sizeTill;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isUpdating() {
        return this.updating;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamTruncationRecord)) {
            return false;
        }
        StreamTruncationRecord other = (StreamTruncationRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableMap<Long, Long> this$streamCut = this.getStreamCut();
        ImmutableMap<Long, Long> other$streamCut = other.getStreamCut();
        if (this$streamCut == null ? other$streamCut != null : !this$streamCut.equals(other$streamCut)) {
            return false;
        }
        ImmutableMap<StreamSegmentRecord, Integer> this$span = this.getSpan();
        ImmutableMap<StreamSegmentRecord, Integer> other$span = other.getSpan();
        if (this$span == null ? other$span != null : !this$span.equals(other$span)) {
            return false;
        }
        if (this.getSpanEpochLow() != other.getSpanEpochLow()) {
            return false;
        }
        if (this.getSpanEpochHigh() != other.getSpanEpochHigh()) {
            return false;
        }
        ImmutableSet<Long> this$deletedSegments = this.getDeletedSegments();
        ImmutableSet<Long> other$deletedSegments = other.getDeletedSegments();
        if (this$deletedSegments == null ? other$deletedSegments != null : !this$deletedSegments.equals(other$deletedSegments)) {
            return false;
        }
        ImmutableSet<Long> this$toDelete = this.getToDelete();
        ImmutableSet<Long> other$toDelete = other.getToDelete();
        if (this$toDelete == null ? other$toDelete != null : !this$toDelete.equals(other$toDelete)) {
            return false;
        }
        if (this.getSizeTill() != other.getSizeTill()) {
            return false;
        }
        return this.isUpdating() == other.isUpdating();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamTruncationRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableMap<Long, Long> $streamCut = this.getStreamCut();
        result = result * 59 + ($streamCut == null ? 43 : $streamCut.hashCode());
        ImmutableMap<StreamSegmentRecord, Integer> $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        result = result * 59 + this.getSpanEpochLow();
        result = result * 59 + this.getSpanEpochHigh();
        ImmutableSet<Long> $deletedSegments = this.getDeletedSegments();
        result = result * 59 + ($deletedSegments == null ? 43 : $deletedSegments.hashCode());
        ImmutableSet<Long> $toDelete = this.getToDelete();
        result = result * 59 + ($toDelete == null ? 43 : $toDelete.hashCode());
        long $sizeTill = this.getSizeTill();
        result = result * 59 + (int)($sizeTill >>> 32 ^ $sizeTill);
        result = result * 59 + (this.isUpdating() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StreamTruncationRecord(streamCut=" + this.getStreamCut() + ", span=" + this.getSpan() + ", spanEpochLow=" + this.getSpanEpochLow() + ", spanEpochHigh=" + this.getSpanEpochHigh() + ", deletedSegments=" + this.getDeletedSegments() + ", toDelete=" + this.getToDelete() + ", sizeTill=" + this.getSizeTill() + ", updating=" + this.isUpdating() + ")";
    }

    private static class TruncationRecordSerializer
    extends VersionedSerializer.WithBuilder<StreamTruncationRecord, StreamTruncationRecordBuilder> {
        private TruncationRecordSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamTruncationRecordBuilder truncationRecordBuilder) throws IOException {
            ImmutableMap.Builder streamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, streamCutBuilder);
            truncationRecordBuilder.streamCut((ImmutableMap<Long, Long>)streamCutBuilder.build());
            ImmutableMap.Builder spanBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(arg_0 -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).deserialize(arg_0), DataInput::readInt, spanBuilder);
            truncationRecordBuilder.span((ImmutableMap<StreamSegmentRecord, Integer>)spanBuilder.build());
            ImmutableSet.Builder deletedSegmentsBuilder = ImmutableSet.builder();
            revisionDataInput.readCollection(DataInput::readLong, (ImmutableCollection.Builder)deletedSegmentsBuilder);
            truncationRecordBuilder.deletedSegments((ImmutableSet<Long>)deletedSegmentsBuilder.build());
            ImmutableSet.Builder toDeleteBuilder = ImmutableSet.builder();
            revisionDataInput.readCollection(DataInput::readLong, (ImmutableCollection.Builder)toDeleteBuilder);
            truncationRecordBuilder.toDelete((ImmutableSet<Long>)toDeleteBuilder.build());
            truncationRecordBuilder.sizeTill(revisionDataInput.readLong()).updating(revisionDataInput.readBoolean());
        }

        private void write00(StreamTruncationRecord streamTruncationRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(streamTruncationRecord.getStreamCut(), DataOutput::writeLong, DataOutput::writeLong);
            revisionDataOutput.writeMap(streamTruncationRecord.getSpan(), (arg_0, arg_1) -> ((StreamSegmentRecord.StreamSegmentRecordSerializer)StreamSegmentRecord.SERIALIZER).serialize(arg_0, arg_1), DataOutput::writeInt);
            revisionDataOutput.writeCollection(streamTruncationRecord.getDeletedSegments(), DataOutput::writeLong);
            revisionDataOutput.writeCollection(streamTruncationRecord.getToDelete(), DataOutput::writeLong);
            revisionDataOutput.writeLong(streamTruncationRecord.sizeTill);
            revisionDataOutput.writeBoolean(streamTruncationRecord.isUpdating());
        }

        protected StreamTruncationRecordBuilder newBuilder() {
            return StreamTruncationRecord.builder();
        }
    }

    private static class StreamTruncationRecordBuilder
    implements ObjectBuilder<StreamTruncationRecord> {
        @SuppressFBWarnings(justification="generated code")
        private ImmutableMap<Long, Long> streamCut;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableMap<StreamSegmentRecord, Integer> span;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableSet<Long> deletedSegments;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableSet<Long> toDelete;
        @SuppressFBWarnings(justification="generated code")
        private long sizeTill;
        @SuppressFBWarnings(justification="generated code")
        private boolean updating;

        @SuppressFBWarnings(justification="generated code")
        StreamTruncationRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder streamCut(@NonNull ImmutableMap<Long, Long> streamCut) {
            if (streamCut == null) {
                throw new NullPointerException("streamCut is marked @NonNull but is null");
            }
            this.streamCut = streamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder span(@NonNull ImmutableMap<StreamSegmentRecord, Integer> span) {
            if (span == null) {
                throw new NullPointerException("span is marked @NonNull but is null");
            }
            this.span = span;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder deletedSegments(@NonNull ImmutableSet<Long> deletedSegments) {
            if (deletedSegments == null) {
                throw new NullPointerException("deletedSegments is marked @NonNull but is null");
            }
            this.deletedSegments = deletedSegments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder toDelete(@NonNull ImmutableSet<Long> toDelete) {
            if (toDelete == null) {
                throw new NullPointerException("toDelete is marked @NonNull but is null");
            }
            this.toDelete = toDelete;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder sizeTill(long sizeTill) {
            this.sizeTill = sizeTill;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecordBuilder updating(boolean updating) {
            this.updating = updating;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public StreamTruncationRecord build() {
            return new StreamTruncationRecord(this.streamCut, this.span, this.deletedSegments, this.toDelete, this.sizeTill, this.updating);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "StreamTruncationRecord.StreamTruncationRecordBuilder(streamCut=" + this.streamCut + ", span=" + this.span + ", deletedSegments=" + this.deletedSegments + ", toDelete=" + this.toDelete + ", sizeTill=" + this.sizeTill + ", updating=" + this.updating + ")";
        }
    }
}

