/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.stream.records;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class WriterMark {
    public static final WriterMarkSerializer SERIALIZER = new WriterMarkSerializer();
    public static final WriterMark EMPTY = new WriterMark(Long.MIN_VALUE, (ImmutableMap<Long, Long>)ImmutableMap.of(), false);
    private final long timestamp;
    private final ImmutableMap<Long, Long> position;
    private final boolean isAlive;

    public WriterMark(long timestamp, ImmutableMap<Long, Long> position) {
        this.timestamp = timestamp;
        this.position = position;
        this.isAlive = true;
    }

    public WriterMark(long timestamp, ImmutableMap<Long, Long> position, boolean isAlive) {
        this.timestamp = timestamp;
        this.position = position;
        this.isAlive = isAlive;
    }

    public static WriterMark fromBytes(byte[] data) {
        return (WriterMark)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    public static WriterMarkBuilder builder() {
        return new WriterMarkBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public long getTimestamp() {
        return this.timestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    public ImmutableMap<Long, Long> getPosition() {
        return this.position;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isAlive() {
        return this.isAlive;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WriterMark)) {
            return false;
        }
        WriterMark other = (WriterMark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        ImmutableMap<Long, Long> this$position = this.getPosition();
        ImmutableMap<Long, Long> other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        return this.isAlive() == other.isAlive();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof WriterMark;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        ImmutableMap<Long, Long> $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        result = result * 59 + (this.isAlive() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "WriterMark(timestamp=" + this.getTimestamp() + ", position=" + this.getPosition() + ", isAlive=" + this.isAlive() + ")";
    }

    private static class WriterMarkSerializer
    extends VersionedSerializer.WithBuilder<WriterMark, WriterMarkBuilder> {
        private WriterMarkSerializer() {
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, WriterMarkBuilder builder) throws IOException {
            builder.timestamp(revisionDataInput.readLong());
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, mapBuilder);
            builder.position((ImmutableMap<Long, Long>)mapBuilder.build());
            builder.isAlive(revisionDataInput.readBoolean());
        }

        private void write00(WriterMark writerMark, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(writerMark.timestamp);
            revisionDataOutput.writeMap((Map)writerMark.position, DataOutput::writeLong, DataOutput::writeLong);
            revisionDataOutput.writeBoolean(writerMark.isAlive);
        }

        protected WriterMarkBuilder newBuilder() {
            return WriterMark.builder();
        }
    }

    public static class WriterMarkBuilder
    implements ObjectBuilder<WriterMark> {
        @SuppressFBWarnings(justification="generated code")
        private long timestamp;
        @SuppressFBWarnings(justification="generated code")
        private ImmutableMap<Long, Long> position;
        @SuppressFBWarnings(justification="generated code")
        private boolean isAlive;

        @SuppressFBWarnings(justification="generated code")
        WriterMarkBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public WriterMarkBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WriterMarkBuilder position(ImmutableMap<Long, Long> position) {
            this.position = position;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WriterMarkBuilder isAlive(boolean isAlive) {
            this.isAlive = isAlive;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WriterMark build() {
            return new WriterMark(this.timestamp, this.position, this.isAlive);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WriterMark.WriterMarkBuilder(timestamp=" + this.timestamp + ", position=" + this.position + ", isAlive=" + this.isAlive + ")";
        }
    }
}

