/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.task;

import com.google.common.base.Preconditions;
import io.pravega.common.hash.RandomFactory;
import io.pravega.controller.store.index.HostIndex;
import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.TaggedResource;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.task.TaskData;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractTaskMetadataStore
implements TaskMetadataStore {
    private static final String TAG_SEPARATOR = "_%%%_";
    private static final String RESOURCE_PART_SEPARATOR = "_%_";
    protected final ScheduledExecutorService executor;
    private final HostIndex hostIndex;

    AbstractTaskMetadataStore(HostIndex hostIndex, ScheduledExecutorService executor) {
        this.hostIndex = hostIndex;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> lock(Resource resource, TaskData taskData, String owner, String tag, String oldOwner, String oldTag) {
        return CompletableFuture.supplyAsync(() -> {
            Preconditions.checkNotNull((Object)resource);
            Preconditions.checkNotNull((Object)taskData);
            Preconditions.checkNotNull((Object)owner);
            Preconditions.checkArgument((!owner.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)tag);
            Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((oldOwner == null && oldTag == null || oldOwner != null && oldTag != null ? 1 : 0) != 0);
            Preconditions.checkArgument((oldOwner == null || !oldOwner.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((oldTag == null || !oldTag.isEmpty() ? 1 : 0) != 0);
            if (oldOwner == null) {
                return this.acquireLock(resource, taskData, owner, tag);
            }
            return this.transferLock(resource, owner, tag, oldOwner, oldTag);
        }, this.executor);
    }

    @Override
    public CompletableFuture<Void> unlock(Resource resource, String owner, String tag) {
        return CompletableFuture.supplyAsync(() -> {
            Preconditions.checkNotNull((Object)resource);
            Preconditions.checkNotNull((Object)owner);
            Preconditions.checkNotNull((Object)tag);
            return this.removeLock(resource, owner, tag);
        }, this.executor);
    }

    abstract Void acquireLock(Resource var1, TaskData var2, String var3, String var4);

    abstract Void transferLock(Resource var1, String var2, String var3, String var4, String var5);

    abstract Void removeLock(Resource var1, String var2, String var3);

    @Override
    public CompletableFuture<Void> putChild(String parent, TaggedResource child) {
        return this.hostIndex.addEntity(parent, this.getNode(child));
    }

    @Override
    public CompletableFuture<Void> removeChild(String parent, TaggedResource child, boolean deleteEmptyParent) {
        return this.hostIndex.removeEntity(parent, this.getNode(child), deleteEmptyParent);
    }

    @Override
    public CompletableFuture<Void> removeNode(String parent) {
        return this.hostIndex.removeHost(parent);
    }

    @Override
    public CompletableFuture<Optional<TaggedResource>> getRandomChild(String parent) {
        return this.hostIndex.getEntities(parent).thenApply(list -> list != null && list.size() > 0 ? Optional.of(this.getTaggedResource((String)list.get(RandomFactory.create().nextInt(list.size())))) : Optional.empty());
    }

    @Override
    public CompletableFuture<Set<String>> getHosts() {
        return this.hostIndex.getHosts();
    }

    protected String getNode(Resource resource) {
        return resource.getString().replaceAll("/", RESOURCE_PART_SEPARATOR);
    }

    protected String getNode(TaggedResource resource) {
        return this.getNode(resource.getResource()) + TAG_SEPARATOR + resource.getTag();
    }

    protected Resource getResource(String node) {
        String[] parts = node.split(RESOURCE_PART_SEPARATOR);
        return new Resource(parts);
    }

    protected TaggedResource getTaggedResource(String node) {
        String[] splits = node.split(TAG_SEPARATOR);
        Preconditions.checkArgument((splits.length == 2 ? 1 : 0) != 0, (Object)"Invalid TaggedResource node");
        return new TaggedResource(splits[1], this.getResource(splits[0]));
    }
}

