/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.task;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.controller.store.task.Resource;
import java.util.UUID;

public class TxnResource
extends Resource {
    private final String scope;
    private final String stream;
    private final UUID txnId;

    public TxnResource(String scope, String stream, UUID txnId) {
        super(scope, stream, txnId.toString());
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        this.scope = scope;
        this.stream = stream;
        this.txnId = txnId;
    }

    public String toString(String delimiter) {
        return String.join((CharSequence)delimiter, this.scope, this.stream, this.txnId.toString());
    }

    public static TxnResource parse(String str, String delimiter) {
        Exceptions.checkNotNullOrEmpty((String)str, (String)"str");
        Exceptions.checkNotNullOrEmpty((String)delimiter, (String)"delimiter");
        String[] parts = str.split(delimiter);
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (Object)"Txn resource requires scope, stream, and txnId");
        return new TxnResource(parts[0], parts[1], UUID.fromString(parts[2]));
    }

    @SuppressFBWarnings(justification="generated code")
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    public UUID getTxnId() {
        return this.txnId;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TxnResource(scope=" + this.getScope() + ", stream=" + this.getStream() + ", txnId=" + this.getTxnId() + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxnResource)) {
            return false;
        }
        TxnResource other = (TxnResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        UUID this$txnId = this.getTxnId();
        UUID other$txnId = other.getTxnId();
        return !(this$txnId == null ? other$txnId != null : !((Object)this$txnId).equals(other$txnId));
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TxnResource;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        UUID $txnId = this.getTxnId();
        result = result * 59 + ($txnId == null ? 43 : ((Object)$txnId).hashCode());
        return result;
    }
}

