/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.store.task;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.controller.store.index.ZKHostIndex;
import io.pravega.controller.store.task.AbstractTaskMetadataStore;
import io.pravega.controller.store.task.LockData;
import io.pravega.controller.store.task.LockFailedException;
import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.UnlockFailedException;
import io.pravega.controller.task.TaskData;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZKTaskMetadataStore
extends AbstractTaskMetadataStore {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ZKTaskMetadataStore.class);
    private final CuratorFramework client;
    private final String taskRoot = "/taskIndex";

    ZKTaskMetadataStore(CuratorFramework client, ScheduledExecutorService executor) {
        super(new ZKHostIndex(client, "/hostTaskIndex", executor), executor);
        this.client = client;
    }

    @Override
    Void acquireLock(Resource resource, TaskData taskData, String owner, String threadId) {
        try {
            LockData lockData = new LockData(owner, threadId, taskData.serialize());
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.getTaskPath(resource), lockData.serialize());
            return null;
        }
        catch (Exception e) {
            throw new LockFailedException(resource.getString(), e);
        }
    }

    @Override
    Void transferLock(Resource resource, String owner, String threadId, String oldOwner, String oldThreadId) {
        boolean lockAcquired = false;
        try {
            Stat stat = new Stat();
            byte[] data = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.getTaskPath(resource));
            LockData lockData = LockData.deserialize(data);
            if (lockData.isOwnedBy(oldOwner, oldThreadId)) {
                lockData = new LockData(owner, threadId, lockData.getTaskData());
                ((BackgroundPathAndBytesable)this.client.setData().withVersion(stat.getVersion())).forPath(this.getTaskPath(resource), lockData.serialize());
                lockAcquired = true;
            }
        }
        catch (Exception e) {
            throw new LockFailedException(resource.getString(), e);
        }
        if (lockAcquired) {
            return null;
        }
        throw new LockFailedException(resource.getString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Void removeLock(Resource resource, String owner, String tag) {
        try {
            Stat stat = new Stat();
            byte[] data = (byte[])((WatchPathable)this.client.getData().storingStatIn(stat)).forPath(this.getTaskPath(resource));
            if (data != null && data.length > 0) {
                LockData lockData = LockData.deserialize(data);
                if (lockData.isOwnedBy(owner, tag)) {
                    ((BackgroundPathable)((ChildrenDeletable)this.client.delete().guaranteed()).withVersion(stat.getVersion())).forPath(this.getTaskPath(resource));
                    return null;
                }
                log.warn("removeLock on resource {} failed, lock not owned by owner ({}, {})", new Object[]{resource, owner, tag});
                throw new UnlockFailedException(resource.getString());
            }
            ((BackgroundPathable)((ChildrenDeletable)this.client.delete().guaranteed()).withVersion(stat.getVersion())).forPath(this.getTaskPath(resource));
            return null;
        }
        catch (KeeperException.NoNodeException e) {
            log.debug("removeLock on {} completed; resource was not locked", (Object)resource);
            return null;
        }
        catch (Exception e) {
            throw new UnlockFailedException(resource.getString(), e);
        }
    }

    @Override
    public CompletableFuture<Optional<TaskData>> getTask(Resource resource, String owner, String tag) {
        return CompletableFuture.supplyAsync(() -> {
            Preconditions.checkNotNull((Object)resource);
            Preconditions.checkNotNull((Object)owner);
            Preconditions.checkNotNull((Object)tag);
            try {
                byte[] data = (byte[])this.client.getData().forPath(this.getTaskPath(resource));
                if (data == null || data.length <= 0) {
                    log.debug("Empty data found for resource {}.", (Object)resource);
                    return Optional.empty();
                }
                LockData lockData = LockData.deserialize(data);
                if (lockData.isOwnedBy(owner, tag)) {
                    return Optional.of(TaskData.deserialize(lockData.getTaskData()));
                }
                log.debug("Resource {} not owned by pair ({}, {})", new Object[]{resource.getString(), owner, tag});
                return Optional.empty();
            }
            catch (KeeperException.NoNodeException e) {
                log.debug("Node {} does not exist.", (Object)this.getTaskPath(resource));
                return Optional.empty();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, this.executor);
    }

    private String getTaskPath(Resource resource) {
        return "/taskIndex/" + this.getNode(resource);
    }
}

