/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task.Stream;

import io.pravega.common.util.Retry;
import io.pravega.controller.retryable.RetryableException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

class TaskStepsRetryHelper {
    private static final long RETRY_INITIAL_DELAY = 100L;
    private static final int RETRY_MULTIPLIER = 10;
    private static final int RETRY_MAX_ATTEMPTS = 10;
    private static final long RETRY_MAX_DELAY = Duration.ofSeconds(10L).toMillis();
    private static final Retry.RetryAndThrowConditionally RETRY = Retry.withExpBackoff((long)100L, (int)10, (int)10, (long)RETRY_MAX_DELAY).retryWhen(RetryableException::isRetryable);

    TaskStepsRetryHelper() {
    }

    static <U> CompletableFuture<U> withRetries(Supplier<CompletableFuture<U>> futureSupplier, ScheduledExecutorService executor) {
        return RETRY.runAsync(futureSupplier, executor);
    }
}

