/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task.Stream;

import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.task.Task;
import io.pravega.controller.task.TaskBase;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public class TestTasks
extends TaskBase {
    public TestTasks(TaskMetadataStore taskMetadataStore, ScheduledExecutorService executor, String hostId) {
        super(taskMetadataStore, executor, hostId);
        this.setReady();
    }

    public TestTasks(TaskMetadataStore taskMetadataStore, ScheduledExecutorService executor, TaskBase.Context context) {
        super(taskMetadataStore, executor, context);
        this.setReady();
    }

    @Task(name="test", version="1.0", resource="{scope}/{stream}")
    public CompletableFuture<Void> testStreamLock(String scope, String stream) {
        return this.execute(new Resource(scope, stream), new Serializable[]{scope, stream}, () -> {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public TaskBase copyWithContext(TaskBase.Context context) {
        return new TestTasks(this.taskMetadataStore, this.executor, context);
    }

    @Override
    public void close() throws Exception {
    }
}

