/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Futures;
import io.pravega.controller.store.task.Resource;
import io.pravega.controller.store.task.TaggedResource;
import io.pravega.controller.store.task.TaskMetadataStore;
import io.pravega.controller.task.Task;
import io.pravega.controller.task.TaskAnnotationNotFoundException;
import io.pravega.controller.task.TaskData;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskBase
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TaskBase.class);
    protected final ScheduledExecutorService executor;
    protected final Context context;
    protected final TaskMetadataStore taskMetadataStore;
    private volatile boolean ready;
    private final CountDownLatch readyLatch;
    private boolean createIndexOnlyMode;

    public TaskBase(TaskMetadataStore taskMetadataStore, ScheduledExecutorService executor, String hostId) {
        this(taskMetadataStore, executor, new Context(hostId));
    }

    protected TaskBase(TaskMetadataStore taskMetadataStore, ScheduledExecutorService executor, Context context) {
        this.taskMetadataStore = taskMetadataStore;
        this.executor = executor;
        this.context = context;
        this.ready = false;
        this.readyLatch = new CountDownLatch(1);
        this.createIndexOnlyMode = false;
    }

    public abstract TaskBase copyWithContext(Context var1);

    public Context getContext() {
        return this.context;
    }

    public <T> CompletableFuture<T> execute(Resource resource, Serializable[] parameters, FutureOperation<T> operation) {
        if (!this.ready) {
            return Futures.failedFuture((Throwable)new IllegalStateException(this.getClass().getName() + " not yet ready"));
        }
        String tag = UUID.randomUUID().toString();
        TaskData taskData = this.getTaskData(parameters);
        CompletableFuture result = new CompletableFuture();
        TaggedResource taggedResource = new TaggedResource(tag, resource);
        log.debug("Host={}, Tag={} starting to execute task {}-{} on resource {}", new Object[]{this.context.hostId, tag, taskData.getMethodName(), taskData.getMethodVersion(), resource});
        if (this.createIndexOnlyMode) {
            return this.createIndexes(taggedResource, taskData);
        }
        ((CompletableFuture)this.taskMetadataStore.putChild(this.context.hostId, taggedResource).thenComposeAsync(x -> this.executeTask(resource, taskData, tag, operation), (Executor)this.executor)).whenCompleteAsync((value, e) -> this.taskMetadataStore.removeChild(this.context.hostId, taggedResource, true).whenCompleteAsync((innerValue, innerE) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(value);
            }
        }, (Executor)this.executor), (Executor)this.executor);
        return result;
    }

    private <T> CompletableFuture<T> createIndexes(TaggedResource taggedResource, TaskData taskData) {
        return ((CompletableFuture)this.taskMetadataStore.putChild(this.context.hostId, taggedResource).thenComposeAsync(x -> this.taskMetadataStore.lock(taggedResource.getResource(), taskData, this.context.hostId, taggedResource.getTag(), this.context.oldHostId, this.context.oldTag), (Executor)this.executor)).thenApplyAsync(x -> {
            throw new IllegalStateException("Index only mode");
        }, (Executor)this.executor);
    }

    protected void setReady() {
        this.ready = true;
        this.readyLatch.countDown();
    }

    protected void setCreateIndexOnlyMode() {
        this.createIndexOnlyMode = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    @VisibleForTesting
    public boolean awaitInitialization(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.readyLatch.await(timeout, timeUnit);
    }

    public void awaitInitialization() throws InterruptedException {
        this.readyLatch.await();
    }

    private <T> CompletableFuture<T> executeTask(Resource resource, TaskData taskData, String tag, FutureOperation<T> operation) {
        CompletableFuture result = new CompletableFuture();
        CompletableFuture lockResult = new CompletableFuture();
        this.taskMetadataStore.lock(resource, taskData, this.context.hostId, tag, this.context.oldHostId, this.context.oldTag).whenCompleteAsync((value, e) -> {
            if (e != null) {
                log.debug("Host={}, Tag={} lock attempt on resource {} failed", new Object[]{this.context.hostId, tag, resource});
                lockResult.completeExceptionally((Throwable)e);
            } else {
                log.debug("Host={}, Tag={} acquired lock on resource {}", new Object[]{this.context.hostId, tag, resource});
                this.removeOldHostChild(tag).whenCompleteAsync((x, y) -> lockResult.complete(value), (Executor)this.executor);
            }
        }, (Executor)this.executor);
        ((CompletableFuture)lockResult.thenComposeAsync(y -> operation.apply(), (Executor)this.executor)).whenCompleteAsync((value, e) -> {
            if (lockResult.isCompletedExceptionally()) {
                result.completeExceptionally((Throwable)e);
            } else {
                log.debug("Host={}, Tag={} completed executing task on resource {}", new Object[]{this.context.hostId, tag, resource});
                this.taskMetadataStore.unlock(resource, this.context.hostId, tag).whenCompleteAsync((innerValue, innerE) -> {
                    log.debug("Host={}, Tag={} unlock attempt completed on resource {}", new Object[]{this.context.hostId, tag, resource});
                    if (e != null) {
                        result.completeExceptionally((Throwable)e);
                    } else {
                        result.complete(value);
                    }
                }, (Executor)this.executor);
            }
        }, (Executor)this.executor);
        return result;
    }

    private CompletableFuture<Void> removeOldHostChild(String tag) {
        if (this.context.oldHostId != null && !this.context.oldHostId.isEmpty()) {
            log.debug("Host={}, Tag={} removing child <{}, {}> of {}", new Object[]{this.context.hostId, tag, this.context.oldResource, this.context.oldTag, this.context.oldHostId});
            return this.taskMetadataStore.removeChild(this.context.oldHostId, new TaggedResource(this.context.oldTag, this.context.oldResource), true);
        }
        return CompletableFuture.completedFuture(null);
    }

    private TaskData getTaskData(Serializable[] parameters) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stacktrace[3];
        Task annotation = this.getTaskAnnotation(e.getMethodName());
        return new TaskData(annotation.name(), annotation.version(), parameters);
    }

    private Task getTaskAnnotation(String method) {
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().equals(method)) continue;
            for (Annotation annotation : m.getDeclaredAnnotations()) {
                if (!(annotation instanceof Task)) continue;
                return (Task)annotation;
            }
            break;
        }
        throw new TaskAnnotationNotFoundException(method);
    }

    public static class Context {
        private final String hostId;
        private final String oldHostId;
        private final String oldTag;
        private final Resource oldResource;

        public Context(String hostId) {
            this.hostId = hostId;
            this.oldHostId = null;
            this.oldTag = null;
            this.oldResource = null;
        }

        public Context(String hostId, String oldHost, String oldTag, Resource oldResource) {
            this.hostId = hostId;
            this.oldHostId = oldHost;
            this.oldTag = oldTag;
            this.oldResource = oldResource;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getHostId() {
            return this.hostId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getOldHostId() {
            return this.oldHostId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getOldTag() {
            return this.oldTag;
        }

        @SuppressFBWarnings(justification="generated code")
        public Resource getOldResource() {
            return this.oldResource;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostId = this.getHostId();
            String other$hostId = other.getHostId();
            if (this$hostId == null ? other$hostId != null : !this$hostId.equals(other$hostId)) {
                return false;
            }
            String this$oldHostId = this.getOldHostId();
            String other$oldHostId = other.getOldHostId();
            if (this$oldHostId == null ? other$oldHostId != null : !this$oldHostId.equals(other$oldHostId)) {
                return false;
            }
            String this$oldTag = this.getOldTag();
            String other$oldTag = other.getOldTag();
            if (this$oldTag == null ? other$oldTag != null : !this$oldTag.equals(other$oldTag)) {
                return false;
            }
            Resource this$oldResource = this.getOldResource();
            Resource other$oldResource = other.getOldResource();
            return !(this$oldResource == null ? other$oldResource != null : !((Object)this$oldResource).equals(other$oldResource));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostId = this.getHostId();
            result = result * 59 + ($hostId == null ? 43 : $hostId.hashCode());
            String $oldHostId = this.getOldHostId();
            result = result * 59 + ($oldHostId == null ? 43 : $oldHostId.hashCode());
            String $oldTag = this.getOldTag();
            result = result * 59 + ($oldTag == null ? 43 : $oldTag.hashCode());
            Resource $oldResource = this.getOldResource();
            result = result * 59 + ($oldResource == null ? 43 : ((Object)$oldResource).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "TaskBase.Context(hostId=" + this.getHostId() + ", oldHostId=" + this.getOldHostId() + ", oldTag=" + this.getOldTag() + ", oldResource=" + this.getOldResource() + ")";
        }
    }

    public static interface FutureOperation<T> {
        public CompletableFuture<T> apply();
    }
}

