/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.task;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.SerializationUtils;

public class TaskData
implements Serializable {
    private final String methodName;
    private final String methodVersion;
    private final Serializable[] parameters;

    TaskData(String methodName, String methodVersion, Serializable[] parameters) {
        this.methodName = methodName;
        this.methodVersion = methodVersion;
        this.parameters = Arrays.copyOf(parameters, parameters.length);
    }

    public byte[] serialize() {
        return SerializationUtils.serialize((Serializable)this);
    }

    public static TaskData deserialize(byte[] bytes) {
        return (TaskData)SerializationUtils.deserialize((byte[])bytes);
    }

    public Serializable[] getParameters() {
        return Arrays.copyOf(this.parameters, this.parameters.length);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getMethodName() {
        return this.methodName;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getMethodVersion() {
        return this.methodVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskData)) {
            return false;
        }
        TaskData other = (TaskData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$methodVersion = this.getMethodVersion();
        String other$methodVersion = other.getMethodVersion();
        if (this$methodVersion == null ? other$methodVersion != null : !this$methodVersion.equals(other$methodVersion)) {
            return false;
        }
        return Arrays.deepEquals(this.getParameters(), other.getParameters());
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TaskData;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $methodVersion = this.getMethodVersion();
        result = result * 59 + ($methodVersion == null ? 43 : $methodVersion.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParameters());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TaskData(methodName=" + this.getMethodName() + ", methodVersion=" + this.getMethodVersion() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
    }
}

