/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.timeout;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.util.RetriesExhaustedException;
import io.pravega.controller.store.stream.StoreException;
import io.pravega.controller.store.stream.Version;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.controller.task.Stream.StreamTransactionMetadataTasks;
import io.pravega.controller.timeout.TimeoutService;
import io.pravega.controller.timeout.TimeoutServiceConfig;
import io.pravega.shared.MetricsTags;
import io.pravega.shared.metrics.DynamicLogger;
import io.pravega.shared.metrics.MetricsProvider;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerWheelTimeoutService
extends AbstractService
implements TimeoutService {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(TimerWheelTimeoutService.class);
    private static final ThreadFactory THREAD_FACTORY = ExecutorServiceHelpers.getThreadFactory((String)"TimerWheelService");
    private static final long TICK_DURATION = 400L;
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final int TICKS_PER_WHEEL = 512;
    private static final boolean LEAK_DETECTION = true;
    private static final DynamicLogger DYNAMIC_LOGGER = MetricsProvider.getDynamicLogger();
    private final StreamTransactionMetadataTasks streamTransactionMetadataTasks;
    private final HashedWheelTimer hashedWheelTimer;
    private final ConcurrentHashMap<String, TxnData> map;
    private final long maxLeaseValue;
    @VisibleForTesting
    private final BlockingQueue<Optional<Throwable>> taskCompletionQueue;

    public TimerWheelTimeoutService(StreamTransactionMetadataTasks streamTransactionMetadataTasks, TimeoutServiceConfig timeoutServiceConfig) {
        this(streamTransactionMetadataTasks, timeoutServiceConfig, null);
    }

    @VisibleForTesting
    public TimerWheelTimeoutService(StreamTransactionMetadataTasks streamTransactionMetadataTasks, TimeoutServiceConfig timeoutServiceConfig, BlockingQueue<Optional<Throwable>> taskCompletionQueue) {
        this.streamTransactionMetadataTasks = streamTransactionMetadataTasks;
        this.hashedWheelTimer = new HashedWheelTimer(THREAD_FACTORY, 400L, TIME_UNIT, 512, true);
        this.map = new ConcurrentHashMap();
        this.maxLeaseValue = timeoutServiceConfig.getMaxLeaseValue();
        this.taskCompletionQueue = taskCompletionQueue;
        this.startAsync();
    }

    protected void doStart() {
        this.hashedWheelTimer.start();
        this.notifyStarted();
    }

    protected void doStop() {
        this.hashedWheelTimer.stop();
        this.map.clear();
        this.notifyStopped();
    }

    @Override
    public void addTxn(String scope, String stream, UUID txnId, Version version, long lease, long maxExecutionTimeExpiry) {
        if (this.isRunning()) {
            String key = this.getKey(scope, stream, txnId);
            this.map.put(key, new TxnData(scope, stream, txnId, version, lease, maxExecutionTimeExpiry));
        }
    }

    @Override
    public void removeTxn(String scope, String stream, UUID txnId) {
        String key = this.getKey(scope, stream, txnId);
        TxnData txnData = this.map.get(key);
        if (txnData != null) {
            txnData.getTimeout().cancel();
            this.map.remove(key, txnData);
        }
    }

    @Override
    public Controller.PingTxnStatus pingTxn(String scope, String stream, UUID txnId, Version version, long lease) {
        if (!this.isRunning()) {
            return Controller.PingTxnStatus.newBuilder().setStatus(Controller.PingTxnStatus.Status.DISCONNECTED).build();
        }
        String key = this.getKey(scope, stream, txnId);
        Preconditions.checkState((boolean)this.map.containsKey(key), (Object)"Stream not found in the map");
        TxnData txnData = this.map.get(key);
        if (txnData == null) {
            throw new IllegalStateException(String.format("Transaction %s not added to timerWheelTimeoutService", txnId));
        }
        if (lease > this.maxLeaseValue) {
            return Controller.PingTxnStatus.newBuilder().setStatus(Controller.PingTxnStatus.Status.LEASE_TOO_LARGE).build();
        }
        if (lease + System.currentTimeMillis() > txnData.getMaxExecutionTimeExpiry()) {
            return Controller.PingTxnStatus.newBuilder().setStatus(Controller.PingTxnStatus.Status.MAX_EXECUTION_TIME_EXCEEDED).build();
        }
        Timeout timeout = txnData.getTimeout();
        boolean cancelSucceeded = timeout.cancel();
        if (cancelSucceeded) {
            TxnData newTxnData = txnData.updateLease(scope, stream, txnId, version, lease);
            this.map.replace(key, txnData, newTxnData);
            return Controller.PingTxnStatus.newBuilder().setStatus(Controller.PingTxnStatus.Status.OK).build();
        }
        throw new IllegalStateException(String.format("Failed updating timeout for transaction %s", txnId));
    }

    @Override
    public boolean containsTxn(String scope, String stream, UUID txnId) {
        return this.map.containsKey(this.getKey(scope, stream, txnId));
    }

    private String getKey(String scope, String stream, UUID txid) {
        return scope + "/" + stream + "/" + txid;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getMaxLeaseValue() {
        return this.maxLeaseValue;
    }

    @SuppressFBWarnings(justification="generated code")
    BlockingQueue<Optional<Throwable>> getTaskCompletionQueue() {
        return this.taskCompletionQueue;
    }

    private class TxnData {
        private final Version version;
        private final long maxExecutionTimeExpiry;
        private final Timeout timeout;

        TxnData(String scope, String stream, UUID txnId, Version version, long lease, long maxExecutionTimeExpiry) {
            this.version = version;
            this.maxExecutionTimeExpiry = maxExecutionTimeExpiry;
            TxnTimeoutTask task = new TxnTimeoutTask(scope, stream, txnId, this);
            this.timeout = TimerWheelTimeoutService.this.hashedWheelTimer.newTimeout((TimerTask)task, lease, TimeUnit.MILLISECONDS);
        }

        public TxnData updateLease(String scope, String stream, UUID txnId, Version version, long lease) {
            return new TxnData(scope, stream, txnId, version, lease, this.maxExecutionTimeExpiry);
        }

        @SuppressFBWarnings(justification="generated code")
        public Version getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getMaxExecutionTimeExpiry() {
            return this.maxExecutionTimeExpiry;
        }

        @SuppressFBWarnings(justification="generated code")
        public Timeout getTimeout() {
            return this.timeout;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TxnData)) {
                return false;
            }
            TxnData other = (TxnData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Version this$version = this.getVersion();
            Version other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            if (this.getMaxExecutionTimeExpiry() != other.getMaxExecutionTimeExpiry()) {
                return false;
            }
            Timeout this$timeout = this.getTimeout();
            Timeout other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof TxnData;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Version $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            long $maxExecutionTimeExpiry = this.getMaxExecutionTimeExpiry();
            result = result * 59 + (int)($maxExecutionTimeExpiry >>> 32 ^ $maxExecutionTimeExpiry);
            Timeout $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "TimerWheelTimeoutService.TxnData(version=" + this.getVersion() + ", maxExecutionTimeExpiry=" + this.getMaxExecutionTimeExpiry() + ", timeout=" + this.getTimeout() + ")";
        }
    }

    private class TxnTimeoutTask
    implements TimerTask {
        private final String scope;
        private final String stream;
        private final UUID txnId;
        private final TxnData txnData;

        public void run(Timeout timeout) throws Exception {
            String key = TimerWheelTimeoutService.this.getKey(this.scope, this.stream, this.txnId);
            log.debug("Executing timeout task for txn {}", (Object)key);
            TimerWheelTimeoutService.this.streamTransactionMetadataTasks.abortTxn(this.scope, this.stream, this.txnId, this.txnData.getVersion(), null).handle((ok, ex) -> {
                if (ex != null) {
                    Throwable error = Exceptions.unwrap((Throwable)ex);
                    if (error instanceof RetriesExhaustedException) {
                        error = Exceptions.unwrap((Throwable)error.getCause());
                    }
                    if (error instanceof StoreException.WriteConflictException || error instanceof StoreException.DataNotFoundException || error instanceof StoreException.IllegalStateException) {
                        log.debug("Timeout task for tx {} failed because of {}. Ignoring timeout task.", (Object)key, (Object)error.getClass().getName());
                        TimerWheelTimeoutService.this.map.remove(key, this.txnData);
                        this.notifyCompletion(error);
                    } else {
                        String errorMsg = String.format("Rescheduling timeout task for tx %s because of transient or unknown error", key);
                        log.warn(errorMsg, ex);
                        TimerWheelTimeoutService.this.hashedWheelTimer.newTimeout((TimerTask)this, 800L, TIME_UNIT);
                    }
                } else {
                    DYNAMIC_LOGGER.incCounterValue("pravega.controller.transactions.timedout", 1L, MetricsTags.streamTags((String)this.scope, (String)this.stream));
                    log.debug("Successfully executed abort on tx {} ", (Object)key);
                    TimerWheelTimeoutService.this.map.remove(key, this.txnData);
                    this.notifyCompletion(null);
                }
                return null;
            });
        }

        private void notifyCompletion(Throwable error) {
            if (TimerWheelTimeoutService.this.taskCompletionQueue != null) {
                if (error != null) {
                    TimerWheelTimeoutService.this.taskCompletionQueue.add(Optional.of(error));
                } else {
                    TimerWheelTimeoutService.this.taskCompletionQueue.add(Optional.empty());
                }
            }
        }

        @ConstructorProperties(value={"scope", "stream", "txnId", "txnData"})
        @SuppressFBWarnings(justification="generated code")
        public TxnTimeoutTask(String scope, String stream, UUID txnId, TxnData txnData) {
            this.scope = scope;
            this.stream = stream;
            this.txnId = txnId;
            this.txnData = txnData;
        }
    }
}

