/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.util;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.controller.server.rpc.grpc.GRPCServerConfig;
import io.pravega.controller.server.rpc.grpc.impl.GRPCServerConfigImpl;
import io.pravega.shared.metrics.MetricsConfig;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Config {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    public static final int RPC_SERVER_PORT;
    public static final int ASYNC_TASK_POOL_SIZE;
    public static final String RPC_PUBLISHED_SERVER_HOST;
    public static final int RPC_PUBLISHED_SERVER_PORT;
    public static final String SERVICE_HOST;
    public static final int SERVICE_PORT;
    public static final int HOST_STORE_CONTAINER_COUNT;
    public static final boolean HOST_MONITOR_ENABLED;
    public static final String CLUSTER_NAME;
    public static final int CLUSTER_MIN_REBALANCE_INTERVAL;
    public static final boolean AUTHORIZATION_ENABLED;
    public static final String USER_PASSWORD_FILE;
    public static final boolean TLS_ENABLED;
    public static final String TLS_KEY_FILE;
    public static final String TLS_CERT_FILE;
    public static final String TLS_TRUST_STORE;
    public static final String TOKEN_SIGNING_KEY;
    public static final int ACCESS_TOKEN_TTL_IN_SECONDS;
    public static final String TLS_ENABLED_FOR_SEGMENT_STORE;
    public static final boolean REPLY_WITH_STACK_TRACE_ON_ERROR;
    public static final boolean REQUEST_TRACING_ENABLED;
    public static final String ZK_URL;
    public static final int ZK_RETRY_SLEEP_MS;
    public static final int ZK_MAX_RETRIES;
    public static final int ZK_SESSION_TIMEOUT_MS;
    public static final boolean SECURE_ZK;
    public static final String ZK_TRUSTSTORE_FILE_PATH;
    public static final String ZK_TRUSTSTORE_PASSWORD_FILE_PATH;
    public static final String REST_SERVER_IP;
    public static final int REST_SERVER_PORT;
    public static final String REST_KEYSTORE_FILE_PATH;
    public static final String REST_KEYSTORE_PASSWORD_FILE_PATH;
    public static final boolean USE_PRAVEGA_TABLES;
    public static final long MIN_LEASE_VALUE;
    public static final long MAX_LEASE_VALUE;
    public static final int COMPLETED_TRANSACTION_TTL_IN_HOURS;
    public static final int MINIMUM_RETENTION_FREQUENCY_IN_MINUTES;
    public static final int RETENTION_BUCKET_COUNT;
    public static final int RETENTION_THREAD_POOL_SIZE;
    public static final int MINIMUM_WATERMARKING_FREQUENCY_IN_SECONDS;
    public static final int WATERMARKING_BUCKET_COUNT;
    public static final int WATERMARKING_THREAD_POOL_SIZE;
    public static final String SCALE_STREAM_NAME;
    public static final String SCALE_READER_GROUP;
    public static final boolean DUMP_STACK_ON_SHUTDOWN;
    public static final MetricsConfig METRICS_CONFIG;
    public static final GRPCServerConfig GRPC_SERVER_CONFIG;
    private static final String METRICS_PATH = "controller.metrics.";
    private static final String NULL_VALUE = "{null}";
    private static final Property<Integer> PROPERTY_CONTAINER_COUNT;
    private static final Property<Boolean> PROPERTY_HOST_MONITORING_ENABLED;
    private static final Property<Integer> PROPERTY_MIN_REBALANCE_INTERVAL_SECONDS;
    private static final Property<Boolean> PROPERTY_REPLY_WITH_STACK_TRACE_ON_ERROR;
    private static final Property<Boolean> PROPERTY_REQUEST_TRACING_ENABLED;
    private static final Property<Boolean> PROPERTY_DUMP_STACK_ON_SHUTDOWN;
    private static final Property<Boolean> PROPERTY_USE_PRAVEGA_TABLES;
    private static final Property<Integer> PROPERTY_SERVICE_PORT;
    private static final Property<Integer> PROPERTY_TASK_POOL_SIZE;
    private static final Property<String> PROPERTY_SERVICE_HOST_IP;
    private static final Property<Integer> PROPERTY_SERVICE_HOST_PORT;
    private static final Property<String> PROPERTY_RPC_HOST;
    private static final Property<Integer> PROPERTY_RPC_PORT;
    private static final Property<String> PROPERTY_CLUSTER_NAME;
    private static final Property<String> PROPERTY_REST_IP;
    private static final Property<Integer> PROPERTY_REST_PORT;
    private static final Property<String> PROPERTY_REST_KEYSTORE_FILE_PATH;
    private static final Property<String> PROPERTY_REST_KEYSTORE_PASSWORD_FILE_PATH;
    private static final Property<Boolean> PROPERTY_AUTH_ENABLED;
    private static final Property<String> PROPERTY_AUTH_PASSWORD_FILE;
    private static final Property<String> PROPERTY_TOKEN_SIGNING_KEY;
    private static final Property<Integer> PROPERTY_ACCESS_TOKEN_TTL_SECONDS;
    private static final Property<Boolean> PROPERTY_TLS_ENABLED;
    private static final Property<String> PROPERTY_TLS_CERT_FILE;
    private static final Property<String> PROPERTY_TLS_TRUST_STORE;
    private static final Property<String> PROPERTY_TLS_KEY_FILE;
    private static final Property<String> PROPERTY_TLS_ENABLED_FOR_SEGMENT_STORE;
    private static final Property<String> PROPERTY_ZK_URL;
    private static final Property<Integer> PROPERTY_ZK_RETRY_MILLIS;
    private static final Property<Integer> PROPERTY_ZK_MAX_RETRY_COUNT;
    private static final Property<Integer> PROPERTY_ZK_SESSION_TIMEOUT_MILLIS;
    private static final Property<Boolean> PROPERTY_ZK_SECURE_CONNECTION;
    private static final Property<String> PROPERTY_ZK_TRUSTSTORE_FILE_PATH;
    private static final Property<String> PROPERTY_ZK_TRUSTSTORE_PASSWORD_FILE_PATH;
    private static final Property<Integer> PROPERTY_RETENTION_FREQUENCY_MINUTES;
    private static final Property<Integer> PROPERTY_RETENTION_BUCKET_COUNT;
    private static final Property<Integer> PROPERTY_RETENTION_THREAD_COUNT;
    private static final Property<Integer> PROPERTY_TXN_MIN_LEASE;
    private static final Property<Integer> PROPERTY_TXN_MAX_LEASE;
    private static final Property<Integer> PROPERTY_TXN_TTL_HOURS;
    private static final Property<Integer> PROPERTY_WATERMARKING_FREQUENCY_SECONDS;
    private static final Property<Integer> PROPERTY_WATERMARKING_BUCKET_COUNT;
    private static final Property<Integer> PROPERTY_WATERMARKING_THREAD_COUNT;
    private static final Property<String> PROPERTY_SCALE_STREAM_NAME;
    private static final Property<String> PROPERTY_SCALE_READER_GROUP;
    private static final String COMPONENT_CODE = "controller";

    private static Properties loadConfiguration() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Config.loadFromFile());
        properties.putAll(System.getenv());
        properties.putAll((Map<?, ?>)System.getProperties());
        properties = Config.resolveReferences(properties);
        log.info("Controller configuration:");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> log.info("{} = {}", k, v)));
        return properties;
    }

    private static Properties loadFromFile() {
        ClassLoader classLoader;
        URL url;
        Properties result = new Properties();
        File file = Config.findConfigFile();
        if (file == null && (url = (classLoader = Config.class.getClassLoader()).getResource("controller.config.properties")) != null && !(file = new File(url.getFile())).exists()) {
            file = null;
        }
        if (file != null) {
            try (FileReader reader = new FileReader(file);){
                result.load(reader);
            }
            log.info("Loaded {} config properties from {}.", (Object)result.size(), (Object)file);
        }
        return result;
    }

    private static File findConfigFile() {
        File result = Arrays.stream(new String[]{"conf.file", "config.file"}).map(System::getProperty).filter(s -> !Strings.isNullOrEmpty((String)s)).map(File::new).filter(File::exists).findFirst().orElse(new File("controller.config.properties"));
        return result.exists() ? result : null;
    }

    private static Properties resolveReferences(Properties properties) {
        String pattern = "^\\$\\{(.+)\\}$";
        Properties resolved = new Properties();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String lookupKey;
            String existingValue;
            String newValue = existingValue = e.getValue().toString();
            if (existingValue.matches("^\\$\\{(.+)\\}$") && (newValue = (String)properties.getOrDefault((Object)(lookupKey = existingValue.replaceAll("^\\$\\{(.+)\\}$", "$1")), (Object)null)) != null) {
                log.info("Config property '{}={}' resolved to '{}'.", new Object[]{e.getKey(), existingValue, newValue});
            }
            if (newValue == null) continue;
            resolved.put(e.getKey().toString(), newValue);
        }
        return resolved;
    }

    private static GRPCServerConfig createGrpcServerConfig() {
        String publishHost = RPC_PUBLISHED_SERVER_HOST;
        if (publishHost != null && publishHost.equals(NULL_VALUE)) {
            publishHost = null;
            log.info("publishedRPCHost is not configured, will use default value");
        }
        return GRPCServerConfigImpl.builder().port(RPC_SERVER_PORT).publishedRPCHost(publishHost).publishedRPCPort(RPC_PUBLISHED_SERVER_PORT).authorizationEnabled(AUTHORIZATION_ENABLED).userPasswordFile(USER_PASSWORD_FILE).tlsEnabled(TLS_ENABLED).tlsCertFile(TLS_CERT_FILE).tlsTrustStore(TLS_TRUST_STORE).tlsKeyFile(TLS_KEY_FILE).tokenSigningKey(TOKEN_SIGNING_KEY).accessTokenTTLInSeconds(ACCESS_TOKEN_TTL_IN_SECONDS).replyWithStackTraceOnError(REPLY_WITH_STACK_TRACE_ON_ERROR).requestTracingEnabled(REQUEST_TRACING_ENABLED).build();
    }

    private static MetricsConfig createMetricsConfig(Properties p) {
        ConfigBuilder builder = MetricsConfig.builder();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(METRICS_PATH)) continue;
            builder.with(Property.named((String)key.substring(METRICS_PATH.length())), e.getValue());
        }
        return (MetricsConfig)builder.build();
    }

    static {
        PROPERTY_CONTAINER_COUNT = Property.named((String)"containerCount", (Object)4);
        PROPERTY_HOST_MONITORING_ENABLED = Property.named((String)"hostMonitorEnabled", (Object)true);
        PROPERTY_MIN_REBALANCE_INTERVAL_SECONDS = Property.named((String)"minRebalanceIntervalSeconds", (Object)10);
        PROPERTY_REPLY_WITH_STACK_TRACE_ON_ERROR = Property.named((String)"replyWithStackTraceOnError", (Object)false);
        PROPERTY_REQUEST_TRACING_ENABLED = Property.named((String)"requestTracingEnabled", (Object)true);
        PROPERTY_DUMP_STACK_ON_SHUTDOWN = Property.named((String)"dumpStackOnShutdown", (Object)false);
        PROPERTY_USE_PRAVEGA_TABLES = Property.named((String)"usePravegaTables", (Object)true);
        PROPERTY_SERVICE_PORT = Property.named((String)"service.port", (Object)9090);
        PROPERTY_TASK_POOL_SIZE = Property.named((String)"service.asyncTaskPoolSize", (Object)80);
        PROPERTY_SERVICE_HOST_IP = Property.named((String)"service.hostIp", (Object)"localhost");
        PROPERTY_SERVICE_HOST_PORT = Property.named((String)"service.hostPort", (Object)12345);
        PROPERTY_RPC_HOST = Property.named((String)"service.publishedRPCHost", (Object)NULL_VALUE);
        PROPERTY_RPC_PORT = Property.named((String)"service.publishedRPCPort", (Object)9090);
        PROPERTY_CLUSTER_NAME = Property.named((String)"service.cluster", (Object)"pravega-cluster");
        PROPERTY_REST_IP = Property.named((String)"service.restIp", (Object)"0.0.0.0");
        PROPERTY_REST_PORT = Property.named((String)"service.restPort", (Object)9091);
        PROPERTY_REST_KEYSTORE_FILE_PATH = Property.named((String)"rest.tlsKeyStoreFile", (Object)"");
        PROPERTY_REST_KEYSTORE_PASSWORD_FILE_PATH = Property.named((String)"rest.tlsKeyStorePasswordFile", (Object)"");
        PROPERTY_AUTH_ENABLED = Property.named((String)"auth.enabled", (Object)false);
        PROPERTY_AUTH_PASSWORD_FILE = Property.named((String)"auth.userPasswordFile", (Object)"");
        PROPERTY_TOKEN_SIGNING_KEY = Property.named((String)"auth.tokenSigningKey", (Object)"");
        PROPERTY_ACCESS_TOKEN_TTL_SECONDS = Property.named((String)"auth.accessTokenTtlSeconds", (Object)600);
        PROPERTY_TLS_ENABLED = Property.named((String)"auth.tlsEnabled", (Object)false);
        PROPERTY_TLS_CERT_FILE = Property.named((String)"auth.tlsCertFile", (Object)"");
        PROPERTY_TLS_TRUST_STORE = Property.named((String)"auth.tlsTrustStore", (Object)"");
        PROPERTY_TLS_KEY_FILE = Property.named((String)"auth.tlsKeyFile", (Object)"");
        PROPERTY_TLS_ENABLED_FOR_SEGMENT_STORE = Property.named((String)"auth.segmentStoreTlsEnabled", (Object)"");
        PROPERTY_ZK_URL = Property.named((String)"zk.url", (Object)"localhost:2181");
        PROPERTY_ZK_RETRY_MILLIS = Property.named((String)"zk.retryIntervalMillis", (Object)5000);
        PROPERTY_ZK_MAX_RETRY_COUNT = Property.named((String)"maxRetries", (Object)5);
        PROPERTY_ZK_SESSION_TIMEOUT_MILLIS = Property.named((String)"sessionTimeoutMillis", (Object)10000);
        PROPERTY_ZK_SECURE_CONNECTION = Property.named((String)"secureConnection", (Object)false);
        PROPERTY_ZK_TRUSTSTORE_FILE_PATH = Property.named((String)"zk.tlsTrustStoreFile", (Object)"");
        PROPERTY_ZK_TRUSTSTORE_PASSWORD_FILE_PATH = Property.named((String)"zk.tlsTrustStorePasswordFile", (Object)"");
        PROPERTY_RETENTION_FREQUENCY_MINUTES = Property.named((String)"retention.frequencyMinutes", (Object)30);
        PROPERTY_RETENTION_BUCKET_COUNT = Property.named((String)"retention.bucketCount", (Object)1);
        PROPERTY_RETENTION_THREAD_COUNT = Property.named((String)"retention.threadCount", (Object)1);
        PROPERTY_TXN_MIN_LEASE = Property.named((String)"transaction.minLeaseValue", (Object)10000);
        PROPERTY_TXN_MAX_LEASE = Property.named((String)"transaction.maxLeaseValue", (Object)120000);
        PROPERTY_TXN_TTL_HOURS = Property.named((String)"transaction.ttlHours", (Object)24);
        PROPERTY_WATERMARKING_FREQUENCY_SECONDS = Property.named((String)"watermarking.frequencySeconds", (Object)10);
        PROPERTY_WATERMARKING_BUCKET_COUNT = Property.named((String)"watermarking.bucketCount", (Object)100);
        PROPERTY_WATERMARKING_THREAD_COUNT = Property.named((String)"watermarking.threadCount", (Object)10);
        PROPERTY_SCALE_STREAM_NAME = Property.named((String)"scale.streamName", (Object)"_requeststream");
        PROPERTY_SCALE_READER_GROUP = Property.named((String)"scale.ReaderGroup", (Object)"scaleGroup");
        Properties properties = Config.loadConfiguration();
        TypedProperties p = new TypedProperties(properties, COMPONENT_CODE);
        RPC_SERVER_PORT = p.getInt(PROPERTY_SERVICE_PORT);
        ASYNC_TASK_POOL_SIZE = p.getInt(PROPERTY_TASK_POOL_SIZE);
        RPC_PUBLISHED_SERVER_HOST = p.get(PROPERTY_RPC_HOST);
        RPC_PUBLISHED_SERVER_PORT = p.getInt(PROPERTY_RPC_PORT);
        SERVICE_HOST = p.get(PROPERTY_SERVICE_HOST_IP);
        SERVICE_PORT = p.getInt(PROPERTY_SERVICE_HOST_PORT);
        HOST_STORE_CONTAINER_COUNT = p.getInt(PROPERTY_CONTAINER_COUNT);
        HOST_MONITOR_ENABLED = p.getBoolean(PROPERTY_HOST_MONITORING_ENABLED);
        CLUSTER_NAME = p.get(PROPERTY_CLUSTER_NAME);
        CLUSTER_MIN_REBALANCE_INTERVAL = p.getInt(PROPERTY_MIN_REBALANCE_INTERVAL_SECONDS);
        AUTHORIZATION_ENABLED = p.getBoolean(PROPERTY_AUTH_ENABLED);
        USER_PASSWORD_FILE = p.get(PROPERTY_AUTH_PASSWORD_FILE);
        TOKEN_SIGNING_KEY = p.get(PROPERTY_TOKEN_SIGNING_KEY);
        ACCESS_TOKEN_TTL_IN_SECONDS = p.getInt(PROPERTY_ACCESS_TOKEN_TTL_SECONDS);
        TLS_ENABLED = p.getBoolean(PROPERTY_TLS_ENABLED);
        TLS_KEY_FILE = p.get(PROPERTY_TLS_KEY_FILE);
        TLS_CERT_FILE = p.get(PROPERTY_TLS_CERT_FILE);
        TLS_TRUST_STORE = p.get(PROPERTY_TLS_TRUST_STORE);
        TLS_ENABLED_FOR_SEGMENT_STORE = p.get(PROPERTY_TLS_ENABLED_FOR_SEGMENT_STORE);
        REPLY_WITH_STACK_TRACE_ON_ERROR = p.getBoolean(PROPERTY_REPLY_WITH_STACK_TRACE_ON_ERROR);
        REQUEST_TRACING_ENABLED = p.getBoolean(PROPERTY_REQUEST_TRACING_ENABLED);
        ZK_URL = p.get(PROPERTY_ZK_URL);
        ZK_RETRY_SLEEP_MS = p.getInt(PROPERTY_ZK_RETRY_MILLIS);
        ZK_MAX_RETRIES = p.getInt(PROPERTY_ZK_MAX_RETRY_COUNT);
        ZK_SESSION_TIMEOUT_MS = p.getInt(PROPERTY_ZK_SESSION_TIMEOUT_MILLIS);
        SECURE_ZK = p.getBoolean(PROPERTY_ZK_SECURE_CONNECTION);
        ZK_TRUSTSTORE_FILE_PATH = p.get(PROPERTY_ZK_TRUSTSTORE_FILE_PATH);
        ZK_TRUSTSTORE_PASSWORD_FILE_PATH = p.get(PROPERTY_ZK_TRUSTSTORE_PASSWORD_FILE_PATH);
        REST_SERVER_IP = p.get(PROPERTY_REST_IP);
        REST_SERVER_PORT = p.getInt(PROPERTY_REST_PORT);
        REST_KEYSTORE_FILE_PATH = p.get(PROPERTY_REST_KEYSTORE_FILE_PATH);
        REST_KEYSTORE_PASSWORD_FILE_PATH = p.get(PROPERTY_REST_KEYSTORE_PASSWORD_FILE_PATH);
        MIN_LEASE_VALUE = p.getInt(PROPERTY_TXN_MIN_LEASE);
        MAX_LEASE_VALUE = p.getInt(PROPERTY_TXN_MAX_LEASE);
        COMPLETED_TRANSACTION_TTL_IN_HOURS = p.getInt(PROPERTY_TXN_TTL_HOURS);
        MINIMUM_RETENTION_FREQUENCY_IN_MINUTES = p.getInt(PROPERTY_RETENTION_FREQUENCY_MINUTES);
        RETENTION_BUCKET_COUNT = p.getInt(PROPERTY_RETENTION_BUCKET_COUNT);
        RETENTION_THREAD_POOL_SIZE = p.getInt(PROPERTY_RETENTION_THREAD_COUNT);
        MINIMUM_WATERMARKING_FREQUENCY_IN_SECONDS = p.getInt(PROPERTY_WATERMARKING_FREQUENCY_SECONDS);
        WATERMARKING_BUCKET_COUNT = p.getInt(PROPERTY_WATERMARKING_BUCKET_COUNT);
        WATERMARKING_THREAD_POOL_SIZE = p.getInt(PROPERTY_WATERMARKING_THREAD_COUNT);
        SCALE_STREAM_NAME = p.get(PROPERTY_SCALE_STREAM_NAME);
        SCALE_READER_GROUP = p.get(PROPERTY_SCALE_READER_GROUP);
        DUMP_STACK_ON_SHUTDOWN = p.getBoolean(PROPERTY_DUMP_STACK_ON_SHUTDOWN);
        USE_PRAVEGA_TABLES = p.getBoolean(PROPERTY_USE_PRAVEGA_TABLES);
        GRPC_SERVER_CONFIG = Config.createGrpcServerConfig();
        METRICS_CONFIG = Config.createMetricsConfig(properties);
    }
}

