/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.util;

import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.Retry;
import io.pravega.controller.retryable.RetryableException;
import io.pravega.controller.store.checkpoint.CheckpointStoreException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RetryHelper {
    public static final Predicate<Throwable> RETRYABLE_PREDICATE = e -> {
        Throwable t = Exceptions.unwrap((Throwable)e);
        return RetryableException.isRetryable(t) || t instanceof CheckpointStoreException && ((CheckpointStoreException)t).getType().equals((Object)CheckpointStoreException.Type.Connectivity);
    };
    public static final Predicate<Throwable> UNCONDITIONAL_PREDICATE = e -> true;

    public static <U> U withRetries(Supplier<U> supplier, Predicate<Throwable> predicate, int numOfTries) {
        return (U)Retry.withExpBackoff((long)100L, (int)2, (int)numOfTries, (long)1000L).retryWhen(predicate).run(supplier::get);
    }

    public static <U> CompletableFuture<U> withRetriesAsync(Supplier<CompletableFuture<U>> futureSupplier, Predicate<Throwable> predicate, int numOfTries, ScheduledExecutorService executor) {
        return Retry.withExpBackoff((long)100L, (int)2, (int)numOfTries, (long)10000L).retryWhen(predicate).runAsync(futureSupplier, executor);
    }

    public static <U> CompletableFuture<U> withIndefiniteRetriesAsync(Supplier<CompletableFuture<U>> futureSupplier, Consumer<Throwable> exceptionConsumer, ScheduledExecutorService executor) {
        return Retry.indefinitelyWithExpBackoff((long)100L, (int)2, (long)10000L, exceptionConsumer).runAsync(futureSupplier, executor);
    }

    public static CompletableFuture<Void> loopWithDelay(Supplier<Boolean> condition, Supplier<CompletableFuture<Void>> loopBody, long delay, ScheduledExecutorService executor) {
        return Futures.loop(condition, () -> Futures.delayedFuture((Supplier)loopBody, (long)delay, (ScheduledExecutorService)executor), (Executor)executor);
    }
}

