/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.controller.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZKUtils {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ZKUtils.class);

    public static void createPathIfNotExists(CuratorFramework client, String basePath, byte[] initData) {
        Preconditions.checkNotNull((Object)client, (Object)"client");
        Preconditions.checkNotNull((Object)basePath, (Object)"basePath");
        Preconditions.checkNotNull((Object)initData, (Object)"initData");
        try {
            if (client.checkExists().forPath(basePath) == null) {
                client.create().creatingParentsIfNeeded().forPath(basePath, initData);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            log.debug("Path exists {}, ignoring exception", (Object)basePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while creating znode: " + basePath, e);
        }
    }
}

