/**
 * Copyright (c) 2019 Dell Inc., or its subsidiaries. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 */

package io.pravega.keycloak.client;

/**
 * Represents a problem related to Keycloak client configuration.
 */
public class KeycloakConfigurationException extends RuntimeException {
    public KeycloakConfigurationException(String message, Throwable e) {
        super(message, e);
    }

    public KeycloakConfigurationException(String message) {
        super(message);
    }

    public KeycloakConfigurationException(Throwable e) {
        super(e);
    }
}
