/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.client;

import io.pravega.keycloak.client.KeycloakAuthzClient;
import io.pravega.shared.security.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaKeycloakCredentials
implements Credentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PravegaKeycloakCredentials.class);
    private transient KeycloakAuthzClient kc = null;
    private final String keycloakJsonString;

    public PravegaKeycloakCredentials() {
        this.init();
        this.keycloakJsonString = null;
        LOG.info("Loaded Keycloak Credentials");
    }

    public PravegaKeycloakCredentials(String keycloakJsonString) {
        this.keycloakJsonString = keycloakJsonString;
        this.init();
        LOG.info("Loaded Keycloak Credentials");
    }

    public String getAuthenticationType() {
        return "Bearer";
    }

    public String getAuthenticationToken() {
        this.init();
        return this.kc.getRPT();
    }

    private void init() {
        if (this.kc == null) {
            this.kc = this.keycloakJsonString != null ? KeycloakAuthzClient.builder().withConfigString(this.keycloakJsonString).build() : KeycloakAuthzClient.builder().build();
        }
    }
}

