/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.com.google.common.io;

import io.pravega.keycloak.com.google.common.annotations.Beta;
import io.pravega.keycloak.com.google.common.annotations.GwtIncompatible;
import io.pravega.keycloak.com.google.common.base.Preconditions;
import io.pravega.keycloak.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@Nullable File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

