/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.asn1.x509;

import io.pravega.keycloak.org.bouncycastle.asn1.ASN1EncodableVector;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Object;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Primitive;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Sequence;
import io.pravega.keycloak.org.bouncycastle.asn1.DERSequence;
import io.pravega.keycloak.org.bouncycastle.asn1.x509.PolicyQualifierInfo;

public class PolicyInformation
extends ASN1Object {
    private ASN1ObjectIdentifier policyIdentifier;
    private ASN1Sequence policyQualifiers;

    private PolicyInformation(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.policyIdentifier = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.policyQualifiers = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public PolicyInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.policyIdentifier = aSN1ObjectIdentifier;
    }

    public PolicyInformation(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Sequence aSN1Sequence) {
        this.policyIdentifier = aSN1ObjectIdentifier;
        this.policyQualifiers = aSN1Sequence;
    }

    public static PolicyInformation getInstance(Object object) {
        if (object == null || object instanceof PolicyInformation) {
            return (PolicyInformation)object;
        }
        return new PolicyInformation(ASN1Sequence.getInstance(object));
    }

    public ASN1ObjectIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public ASN1Sequence getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            aSN1EncodableVector.add(this.policyQualifiers);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policy information: ");
        stringBuffer.append(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            StringBuffer stringBuffer2 = new StringBuffer();
            for (int i = 0; i < this.policyQualifiers.size(); ++i) {
                if (stringBuffer2.length() != 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(PolicyQualifierInfo.getInstance(this.policyQualifiers.getObjectAt(i)));
            }
            stringBuffer.append("[");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }
}

