/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cms;

import io.pravega.keycloak.org.bouncycastle.asn1.cms.KEKIdentifier;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import io.pravega.keycloak.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.pravega.keycloak.org.bouncycastle.cms.AuthAttributesProvider;
import io.pravega.keycloak.org.bouncycastle.cms.CMSException;
import io.pravega.keycloak.org.bouncycastle.cms.CMSSecureReadable;
import io.pravega.keycloak.org.bouncycastle.cms.KEKRecipient;
import io.pravega.keycloak.org.bouncycastle.cms.KEKRecipientId;
import io.pravega.keycloak.org.bouncycastle.cms.Recipient;
import io.pravega.keycloak.org.bouncycastle.cms.RecipientInformation;
import io.pravega.keycloak.org.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

