/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.generators;

import io.pravega.keycloak.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.pravega.keycloak.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.pravega.keycloak.org.bouncycastle.crypto.KeyGenerationParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECDomainParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECConstants;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECMultiplier;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECPoint;
import io.pravega.keycloak.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import io.pravega.keycloak.org.bouncycastle.math.ec.WNafUtil;
import io.pravega.keycloak.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

