/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client.util;

import io.pravega.keycloak.org.apache.http.client.methods.RequestBuilder;
import io.pravega.keycloak.org.keycloak.authorization.client.ClientAuthenticator;
import io.pravega.keycloak.org.keycloak.authorization.client.Configuration;
import io.pravega.keycloak.org.keycloak.authorization.client.representation.ServerConfiguration;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpMethod;

public class Http {
    private final Configuration configuration;
    private final ClientAuthenticator authenticator;
    private ServerConfiguration serverConfiguration;

    public Http(Configuration configuration, ClientAuthenticator authenticator) {
        this.configuration = configuration;
        this.authenticator = authenticator;
    }

    public <R> HttpMethod<R> get(String path) {
        return this.method(RequestBuilder.get().setUri(path));
    }

    public <R> HttpMethod<R> post(String path) {
        return this.method(RequestBuilder.post().setUri(path));
    }

    public <R> HttpMethod<R> put(String path) {
        return this.method(RequestBuilder.put().setUri(path));
    }

    public <R> HttpMethod<R> delete(String path) {
        return this.method(RequestBuilder.delete().setUri(path));
    }

    private <R> HttpMethod<R> method(RequestBuilder builder) {
        return new HttpMethod(this.configuration, this.authenticator, builder);
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }
}

