/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe.enc;

import io.pravega.keycloak.org.keycloak.jose.jwe.JWE;
import io.pravega.keycloak.org.keycloak.jose.jwe.JWEKeyStorage;
import io.pravega.keycloak.org.keycloak.jose.jwe.JWEUtils;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AesGcmEncryptionProvider
implements JWEEncryptionProvider {
    private static final int AUTH_TAG_SIZE_BYTE = 16;
    private static final int IV_SIZE_BYTE = 12;

    @Override
    public void encodeJwe(JWE jwe) throws Exception {
        byte[] contentBytes = jwe.getContent();
        byte[] initializationVector = JWEUtils.generateSecret(12);
        Key aesKey = jwe.getKeyStorage().getCEKKey(JWEKeyStorage.KeyUse.ENCRYPTION, false);
        if (aesKey == null) {
            throw new IllegalArgumentException("AES CEK key not present");
        }
        int expectedAesKeyLength = this.getExpectedAesKeyLength();
        if (expectedAesKeyLength != aesKey.getEncoded().length) {
            throw new IllegalStateException("Length of aes key should be " + expectedAesKeyLength + ", but was " + aesKey.getEncoded().length);
        }
        byte[] aad = jwe.getBase64Header().getBytes(StandardCharsets.UTF_8);
        byte[] cipherBytes = this.encryptBytes(contentBytes, initializationVector, aesKey, aad);
        byte[] authenticationTag = this.getAuthenticationTag(cipherBytes);
        byte[] encryptedContent = this.getEncryptedContent(cipherBytes);
        jwe.setEncryptedContentInfo(initializationVector, encryptedContent, authenticationTag);
    }

    @Override
    public void verifyAndDecodeJwe(JWE jwe) throws Exception {
        Key aesKey = jwe.getKeyStorage().getCEKKey(JWEKeyStorage.KeyUse.ENCRYPTION, false);
        if (aesKey == null) {
            throw new IllegalArgumentException("AES CEK key not present");
        }
        int expectedAesKeyLength = this.getExpectedAesKeyLength();
        if (expectedAesKeyLength != aesKey.getEncoded().length) {
            throw new IllegalStateException("Length of aes key should be " + expectedAesKeyLength + ", but was " + aesKey.getEncoded().length);
        }
        byte[] aad = jwe.getBase64Header().getBytes(StandardCharsets.UTF_8);
        byte[] decryptedTargetContent = this.getAeadDecryptedTargetContent(jwe);
        byte[] contentBytes = this.decryptBytes(decryptedTargetContent, jwe.getInitializationVector(), aesKey, aad);
        jwe.content(contentBytes);
    }

    private byte[] encryptBytes(byte[] contentBytes, byte[] ivBytes, Key aesKey, byte[] aad) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec gcmParams = new GCMParameterSpec(128, ivBytes);
        cipher.init(1, aesKey, gcmParams);
        cipher.updateAAD(aad);
        byte[] cipherText = new byte[cipher.getOutputSize(contentBytes.length)];
        cipher.doFinal(contentBytes, 0, contentBytes.length, cipherText);
        return cipherText;
    }

    private byte[] decryptBytes(byte[] encryptedBytes, byte[] ivBytes, Key aesKey, byte[] aad) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec gcmParams = new GCMParameterSpec(128, ivBytes);
        cipher.init(2, aesKey, gcmParams);
        cipher.updateAAD(aad);
        return cipher.doFinal(encryptedBytes);
    }

    private byte[] getAuthenticationTag(byte[] cipherBytes) {
        byte[] authenticationTag = new byte[16];
        System.arraycopy(cipherBytes, cipherBytes.length - authenticationTag.length, authenticationTag, 0, authenticationTag.length);
        return authenticationTag;
    }

    private byte[] getEncryptedContent(byte[] cipherBytes) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] encryptedContent = new byte[cipherBytes.length - 16];
        System.arraycopy(cipherBytes, 0, encryptedContent, 0, encryptedContent.length);
        return encryptedContent;
    }

    private byte[] getAeadDecryptedTargetContent(JWE jwe) {
        byte[] encryptedContent = jwe.getEncryptedContent();
        byte[] authTag = jwe.getAuthenticationTag();
        byte[] decryptedTargetContent = new byte[authTag.length + encryptedContent.length];
        System.arraycopy(encryptedContent, 0, decryptedTargetContent, 0, encryptedContent.length);
        System.arraycopy(authTag, 0, decryptedTargetContent, encryptedContent.length, authTag.length);
        return decryptedTargetContent;
    }

    @Override
    public byte[] serializeCEK(JWEKeyStorage keyStorage) {
        Key aesKey = keyStorage.getCEKKey(JWEKeyStorage.KeyUse.ENCRYPTION, false);
        if (aesKey == null) {
            throw new IllegalArgumentException("AES CEK key not present");
        }
        byte[] aesBytes = aesKey.getEncoded();
        return aesBytes;
    }

    @Override
    public void deserializeCEK(JWEKeyStorage keyStorage) {
        byte[] cekBytes = keyStorage.getCekBytes();
        SecretKeySpec aesKey = new SecretKeySpec(cekBytes, "AES");
        keyStorage.setCEKKey(aesKey, JWEKeyStorage.KeyUse.ENCRYPTION);
    }

    protected abstract int getExpectedAesKeyLength();
}

