/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwk;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.keycloak.org.keycloak.common.util.PemUtils;
import io.pravega.keycloak.org.keycloak.jose.jwk.JWK;
import java.security.NoSuchAlgorithmException;

public class RSAPublicJWK
extends JWK {
    public static final String RSA = "RSA";
    public static final String RS256 = "RS256";
    public static final String MODULUS = "n";
    public static final String PUBLIC_EXPONENT = "e";
    @JsonProperty(value="n")
    private String modulus;
    @JsonProperty(value="e")
    private String publicExponent;
    @JsonProperty(value="x5c")
    private String[] x509CertificateChain;
    private String sha1x509Thumbprint;
    private String sha256x509Thumbprint;

    public String getModulus() {
        return this.modulus;
    }

    public void setModulus(String modulus) {
        this.modulus = modulus;
    }

    public String getPublicExponent() {
        return this.publicExponent;
    }

    public void setPublicExponent(String publicExponent) {
        this.publicExponent = publicExponent;
    }

    public String[] getX509CertificateChain() {
        return this.x509CertificateChain;
    }

    public void setX509CertificateChain(String[] x509CertificateChain) {
        this.x509CertificateChain = x509CertificateChain;
        if (x509CertificateChain != null && x509CertificateChain.length > 0) {
            try {
                this.sha1x509Thumbprint = PemUtils.generateThumbprint(x509CertificateChain, "SHA-1");
                this.sha256x509Thumbprint = PemUtils.generateThumbprint(x509CertificateChain, "SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @JsonProperty(value="x5t")
    public String getSha1x509Thumbprint() {
        return this.sha1x509Thumbprint;
    }

    @JsonProperty(value="x5t#S256")
    public String getSha256x509Thumbprint() {
        return this.sha256x509Thumbprint;
    }
}

