/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cms;

import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Encodable;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.pravega.keycloak.org.bouncycastle.asn1.DEROctetString;
import io.pravega.keycloak.org.bouncycastle.asn1.DERSet;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.Attribute;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.AttributeTable;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.CMSAttributes;
import io.pravega.keycloak.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.pravega.keycloak.org.bouncycastle.cms.CMSAttributeTableGenerator;
import java.util.Hashtable;
import java.util.Map;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Object object;
        Hashtable hashtable = new Hashtable();
        Object object2 = this.table.keys();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            hashtable.put(object, this.table.get(object));
        }
        if (!hashtable.containsKey(CMSAttributes.contentType)) {
            object2 = ASN1ObjectIdentifier.getInstance(map.get("contentType"));
            object = new Attribute(CMSAttributes.contentType, new DERSet((ASN1Encodable)object2));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object2 = (byte[])map.get("digest");
            object = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])object2)));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        if (!hashtable.contains(CMSAttributes.cmsAlgorithmProtect)) {
            object2 = new Attribute(CMSAttributes.cmsAlgorithmProtect, new DERSet(new CMSAlgorithmProtection((AlgorithmIdentifier)map.get("digestAlgID"), 2, (AlgorithmIdentifier)map.get("macAlgID"))));
            hashtable.put(((Attribute)object2).getAttrType(), object2);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

