/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.its.asn1;

import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Object;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1OctetString;
import io.pravega.keycloak.org.bouncycastle.asn1.ASN1Primitive;
import io.pravega.keycloak.org.bouncycastle.asn1.DEROctetString;
import io.pravega.keycloak.org.bouncycastle.its.asn1.Utils;
import io.pravega.keycloak.org.bouncycastle.util.Arrays;

public class LinkageValue
extends ASN1Object {
    private final byte[] value;

    private LinkageValue(ASN1OctetString aSN1OctetString) {
        this.value = Arrays.clone(Utils.octetStringFixed(aSN1OctetString.getOctets(), 9));
    }

    public static LinkageValue getInstance(Object object) {
        if (object instanceof LinkageValue) {
            return (LinkageValue)object;
        }
        if (object != null) {
            return new LinkageValue(ASN1OctetString.getInstance(object));
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DEROctetString(Arrays.clone(this.value));
    }
}

