/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.jcajce.provider.asymmetric.edec;

import io.pravega.keycloak.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.params.X448PublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import io.pravega.keycloak.org.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.interfaces.XECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;

class BC11XDHPublicKey
extends BCXDHPublicKey
implements XECPublicKey {
    BC11XDHPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(asymmetricKeyParameter);
    }

    BC11XDHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(subjectPublicKeyInfo);
    }

    BC11XDHPublicKey(byte[] byArray, byte[] byArray2) throws InvalidKeySpecException {
        super(byArray, byArray2);
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        if (this.xdhPublicKey instanceof X448PublicKeyParameters) {
            return NamedParameterSpec.X448;
        }
        return NamedParameterSpec.X25519;
    }

    @Override
    public BigInteger getU() {
        if (this.xdhPublicKey instanceof X448PublicKeyParameters) {
            return new BigInteger(1, Arrays.reverse(((X448PublicKeyParameters)this.xdhPublicKey).getEncoded()));
        }
        return new BigInteger(1, Arrays.reverse(((X25519PublicKeyParameters)this.xdhPublicKey).getEncoded()));
    }
}

