/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.authorization.client.util;

import io.pravega.keycloak.org.apache.http.HttpEntity;
import io.pravega.keycloak.org.apache.http.HttpResponse;
import io.pravega.keycloak.org.apache.http.StatusLine;
import io.pravega.keycloak.org.apache.http.client.HttpClient;
import io.pravega.keycloak.org.apache.http.client.entity.UrlEncodedFormEntity;
import io.pravega.keycloak.org.apache.http.client.methods.RequestBuilder;
import io.pravega.keycloak.org.apache.http.entity.ByteArrayEntity;
import io.pravega.keycloak.org.apache.http.message.BasicNameValuePair;
import io.pravega.keycloak.org.apache.http.util.EntityUtils;
import io.pravega.keycloak.org.keycloak.authorization.client.ClientAuthenticator;
import io.pravega.keycloak.org.keycloak.authorization.client.Configuration;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpMethodAuthenticator;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpMethodResponse;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpResponseException;
import io.pravega.keycloak.org.keycloak.authorization.client.util.HttpResponseProcessor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpMethod<R> {
    private final HttpClient httpClient;
    private final ClientAuthenticator authenticator;
    protected final RequestBuilder builder;
    protected final Configuration configuration;
    protected final Map<String, String> headers;
    protected final Map<String, List<String>> params;
    private HttpMethodResponse<R> response;

    public HttpMethod(Configuration configuration, ClientAuthenticator authenticator, RequestBuilder builder) {
        this(configuration, authenticator, builder, new HashMap<String, List<String>>(), new HashMap<String, String>());
    }

    public HttpMethod(Configuration configuration, ClientAuthenticator authenticator, RequestBuilder builder, Map<String, List<String>> params, Map<String, String> headers) {
        this.configuration = configuration;
        this.httpClient = configuration.getHttpClient();
        this.authenticator = authenticator;
        this.builder = builder;
        this.params = params;
        this.headers = headers;
    }

    public void execute() {
        this.execute(new HttpResponseProcessor<R>(){

            @Override
            public R process(byte[] entity) {
                return null;
            }
        });
    }

    public R execute(HttpResponseProcessor<R> responseProcessor) {
        byte[] bytes = null;
        try {
            StatusLine statusLine;
            int statusCode;
            for (Map.Entry<String, String> header : this.headers.entrySet()) {
                this.builder.setHeader(header.getKey(), header.getValue());
            }
            this.preExecute(this.builder);
            HttpResponse response = this.httpClient.execute(this.builder.build());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                bytes = EntityUtils.toByteArray(entity);
            }
            if ((statusCode = (statusLine = response.getStatusLine()).getStatusCode()) < 200 || statusCode >= 300) {
                throw new HttpResponseException("Unexpected response from server: " + statusCode + " / " + statusLine.getReasonPhrase(), statusCode, statusLine.getReasonPhrase(), bytes);
            }
            if (bytes == null) {
                return null;
            }
            return responseProcessor.process(bytes);
        }
        catch (HttpResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing http method [" + this.builder.getMethod() + "]. Response : " + String.valueOf(bytes), e);
        }
    }

    protected void preExecute(RequestBuilder builder) {
        for (Map.Entry<String, List<String>> param : this.params.entrySet()) {
            for (String value : param.getValue()) {
                builder.addParameter(param.getKey(), value);
            }
        }
    }

    public HttpMethod<R> authorizationBearer(String bearer) {
        this.builder.addHeader("Authorization", "Bearer " + bearer);
        return this;
    }

    public HttpMethodResponse<R> response() {
        this.response = new HttpMethodResponse(this);
        return this.response;
    }

    public HttpMethodAuthenticator<R> authentication() {
        return new HttpMethodAuthenticator(this, this.authenticator);
    }

    public HttpMethod<R> param(String name, String value) {
        if (value != null) {
            List<String> values = this.params.get(name);
            if (values == null || !values.isEmpty()) {
                values = new ArrayList<String>();
                this.params.put(name, values);
            }
            values.add(value);
        }
        return this;
    }

    public HttpMethod<R> params(String name, String value) {
        if (value != null) {
            List<String> values = this.params.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.params.put(name, values);
            }
            values.add(value);
        }
        return this;
    }

    public HttpMethod<R> json(byte[] entity) {
        this.builder.addHeader("Content-Type", "application/json");
        this.builder.setEntity(new ByteArrayEntity(entity));
        return this;
    }

    public HttpMethod<R> form() {
        return new HttpMethod<R>(this.configuration, this.authenticator, this.builder, this.params, this.headers){

            @Override
            protected void preExecute(RequestBuilder builder) {
                if (this.params != null) {
                    ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry param : this.params.entrySet()) {
                        for (String value : (List)param.getValue()) {
                            formparams.add(new BasicNameValuePair((String)param.getKey(), value));
                        }
                    }
                    try {
                        builder.setEntity(new UrlEncodedFormEntity(formparams, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Error creating form parameters");
                    }
                }
            }
        };
    }
}

