/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.common.util;

import io.pravega.keycloak.org.jboss.logging.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class StackUtil {
    private static final Logger LOG = Logger.getLogger("io.pravega.keycloak.org.keycloak.STACK_TRACE");
    private static final ConcurrentHashMap<String, Object> STACK_TRACE_OBJECTS = new ConcurrentHashMap();
    private static final Pattern IGNORED = Pattern.compile("sun\\.|java\\.(lang|util|stream)\\.|org\\.jboss\\.(arquillian|logging).|org.apache.maven.surefire|org\\.junit\\.|org.keycloak.testsuite.model.KeycloakModelTest\\.");
    private static final StringBuilder EMPTY = new StringBuilder(0);

    public static Object getShortStackTrace() {
        return StackUtil.getShortStackTrace("\n    ");
    }

    public static Object getShortStackTrace(String prefix) {
        if (!StackUtil.isShortStackTraceEnabled()) {
            return EMPTY;
        }
        Object res = STACK_TRACE_OBJECTS.get(prefix);
        if (res == null) {
            res = StackUtil.stackTraceObject(prefix);
            STACK_TRACE_OBJECTS.put(prefix, res);
        }
        return res;
    }

    private static Object stackTraceObject(final String prefix) {
        return new Object(){

            public String toString() {
                StringBuilder sb = new StringBuilder();
                StackTraceElement[] stackTrace = new Throwable().getStackTrace();
                boolean stackTraceStarted = false;
                for (int endIndex = 0; endIndex < stackTrace.length; ++endIndex) {
                    StackTraceElement st = stackTrace[endIndex];
                    if (!stackTraceStarted) {
                        stackTraceStarted = this.getClass().getName().equals(st.getClassName());
                        ++endIndex;
                        continue;
                    }
                    if (IGNORED.matcher(st.getClassName()).find()) continue;
                    if (st.getClassName().startsWith("org.jboss.resteasy")) break;
                    sb.append(prefix).append(st);
                }
                return sb.toString();
            }
        };
    }

    public static boolean isShortStackTraceEnabled() {
        return LOG.isTraceEnabled();
    }
}

