/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe;

import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnore;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonInclude;
import io.pravega.keycloak.com.fasterxml.jackson.annotation.JsonProperty;
import io.pravega.keycloak.com.fasterxml.jackson.databind.ObjectMapper;
import io.pravega.keycloak.org.keycloak.jose.JOSEHeader;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWEHeader
implements JOSEHeader {
    @JsonProperty(value="alg")
    private String algorithm;
    @JsonProperty(value="enc")
    private String encryptionAlgorithm;
    @JsonProperty(value="zip")
    private String compressionAlgorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWEHeader() {
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm, String keyId) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.keyId = keyId;
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm, String keyId, String contentType) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.keyId = keyId;
        this.contentType = contentType;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @JsonIgnore
    public String getRawAlgorithm() {
        return this.getAlgorithm();
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

