/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.jose.jwe.alg;

import io.pravega.keycloak.org.keycloak.jose.jwe.JWEKeyStorage;
import io.pravega.keycloak.org.keycloak.jose.jwe.alg.KeyEncryptionJWEAlgorithmProvider;
import io.pravega.keycloak.org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RsaKeyEncryption256JWEAlgorithmProvider
extends KeyEncryptionJWEAlgorithmProvider {
    private final String jcaAlgorithmName;

    public RsaKeyEncryption256JWEAlgorithmProvider(String jcaAlgorithmName) {
        this.jcaAlgorithmName = jcaAlgorithmName;
    }

    @Override
    protected Cipher getCipherProvider() throws Exception {
        return Cipher.getInstance(this.jcaAlgorithmName);
    }

    @Override
    public byte[] decodeCek(byte[] encodedCek, Key privateKey) throws Exception {
        AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
        OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        algp.init(paramSpec);
        Cipher cipher = this.getCipherProvider();
        cipher.init(2, privateKey, algp);
        return cipher.doFinal(encodedCek);
    }

    @Override
    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key publicKey) throws Exception {
        AlgorithmParameters algp = AlgorithmParameters.getInstance("OAEP");
        OAEPParameterSpec paramSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
        algp.init(paramSpec);
        Cipher cipher = this.getCipherProvider();
        cipher.init(1, publicKey, algp);
        byte[] cekBytes = keyStorage.getCekBytes();
        return cipher.doFinal(cekBytes);
    }
}

