/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.client;

import io.pravega.keycloak.com.google.common.base.Strings;
import io.pravega.keycloak.org.keycloak.authorization.client.Configuration;
import io.pravega.keycloak.org.keycloak.util.JsonSerialization;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakConfigResolver.class);
    public static final String ENV_KEYCLOAK_SVC_CREDS_FILE = "KEYCLOAK_SERVICE_ACCOUNT_FILE";
    public static final String RESOURCE_KEYCLOAK_JSON = "keycloak.json";

    public static Optional<Configuration> resolve() throws IOException {
        return KeycloakConfigResolver.resolve(null);
    }

    public static Optional<Configuration> resolve(String fileLocation) throws IOException {
        return KeycloakConfigResolver.resolve(null, fileLocation);
    }

    public static Optional<Configuration> resolveFromString(String configString) throws IOException {
        return KeycloakConfigResolver.resolve(configString, null);
    }

    static Optional<Configuration> resolve(String configString, String fileLocation) throws IOException {
        Optional<InputStream> stream = KeycloakConfigResolver.open(configString, fileLocation, System.getenv(), Thread.currentThread().getContextClassLoader());
        if (!stream.isPresent()) {
            LOG.debug("Keycloak adapter configuration not found");
            return Optional.empty();
        }
        Throwable throwable = null;
        try (InputStream configStream = stream.get();){
            Optional<Configuration> optional = Optional.of(JsonSerialization.readValue(configStream, Configuration.class));
            return optional;
        }
        catch (Exception e) {
            try {
                throw new IOException("Could not parse configuration.", e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static Optional<InputStream> open(String configString, String fileLocation, Map<String, String> envs, ClassLoader classLoader) throws IOException {
        Optional<InputStream> stream = KeycloakConfigResolver.string(configString);
        if (stream.isPresent()) {
            return stream;
        }
        stream = KeycloakConfigResolver.path(fileLocation);
        if (stream.isPresent()) {
            return stream;
        }
        stream = KeycloakConfigResolver.env(envs);
        if (stream.isPresent()) {
            return stream;
        }
        stream = KeycloakConfigResolver.classpath(classLoader);
        return stream;
    }

    static Optional<InputStream> string(String configString) {
        if (!Strings.isNullOrEmpty(configString)) {
            LOG.debug("Loaded configuration from string");
            return Optional.of(new ByteArrayInputStream(configString.getBytes(StandardCharsets.UTF_8)));
        }
        return Optional.empty();
    }

    static Optional<InputStream> path(String fileLocation) throws IOException {
        Optional<Path> path = KeycloakConfigResolver.pathIfExists(fileLocation);
        if (path.isPresent()) {
            LOG.debug("Loaded configuration from file: {}", path);
            return Optional.of(Files.newInputStream(path.get(), new OpenOption[0]));
        }
        return Optional.empty();
    }

    static Optional<InputStream> env(Map<String, String> envs) throws IOException {
        return KeycloakConfigResolver.path(envs.get(ENV_KEYCLOAK_SVC_CREDS_FILE));
    }

    static Optional<InputStream> classpath(ClassLoader classLoader) throws IOException {
        Optional<InputStream> stream = Optional.ofNullable(classLoader.getResourceAsStream(RESOURCE_KEYCLOAK_JSON));
        if (stream.isPresent()) {
            LOG.debug("Loaded configuration from classpath");
        }
        return stream;
    }

    static Optional<Path> pathIfExists(String pathStr) {
        return Optional.ofNullable(pathStr).map(x$0 -> Paths.get(x$0, new String[0])).filter(Files::isReadable);
    }
}

