/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cert.crmf.bc;

import io.pravega.keycloak.org.bouncycastle.asn1.crmf.EncryptedValue;
import io.pravega.keycloak.org.bouncycastle.cert.crmf.CRMFException;
import io.pravega.keycloak.org.bouncycastle.cert.crmf.EncryptedValueBuilder;
import io.pravega.keycloak.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import io.pravega.keycloak.org.bouncycastle.operator.KeyWrapper;
import io.pravega.keycloak.org.bouncycastle.operator.OutputEncryptor;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class BcEncryptedValueBuilder
extends EncryptedValueBuilder {
    public BcEncryptedValueBuilder(KeyWrapper keyWrapper, OutputEncryptor outputEncryptor) {
        super(keyWrapper, outputEncryptor);
    }

    public EncryptedValue build(X509Certificate x509Certificate) throws CertificateEncodingException, CRMFException {
        return this.build(new JcaX509CertificateHolder(x509Certificate));
    }

    public EncryptedValue build(AsymmetricKeyParameter asymmetricKeyParameter) throws CRMFException, IOException {
        return this.build(PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter));
    }
}

