/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.cms;

import io.pravega.keycloak.org.bouncycastle.asn1.DEROctetString;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import io.pravega.keycloak.org.bouncycastle.asn1.cms.SignerIdentifier;
import io.pravega.keycloak.org.bouncycastle.cert.X509CertificateHolder;
import io.pravega.keycloak.org.bouncycastle.cms.CMSAttributeTableGenerator;
import io.pravega.keycloak.org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import io.pravega.keycloak.org.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import io.pravega.keycloak.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import io.pravega.keycloak.org.bouncycastle.cms.SignerInfoGenerator;
import io.pravega.keycloak.org.bouncycastle.operator.ContentSigner;
import io.pravega.keycloak.org.bouncycastle.operator.DigestCalculatorProvider;
import io.pravega.keycloak.org.bouncycastle.operator.OperatorCreationException;

public class SignerInfoGeneratorBuilder {
    private DigestCalculatorProvider digestProvider;
    private boolean directSignature;
    private CMSAttributeTableGenerator signedGen;
    private CMSAttributeTableGenerator unsignedGen;
    private CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder;

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this(digestCalculatorProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder) {
        this.digestProvider = digestCalculatorProvider;
        this.sigEncAlgFinder = cMSSignatureEncryptionAlgorithmFinder;
    }

    public SignerInfoGeneratorBuilder setDirectSignature(boolean bl) {
        this.directSignature = bl;
        return this;
    }

    public SignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.signedGen = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.unsignedGen = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure()));
        SignerInfoGenerator signerInfoGenerator = this.createGenerator(contentSigner, signerIdentifier);
        signerInfoGenerator.setAssociatedCertificate(x509CertificateHolder);
        return signerInfoGenerator;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] byArray) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new DEROctetString(byArray));
        return this.createGenerator(contentSigner, signerIdentifier);
    }

    private SignerInfoGenerator createGenerator(ContentSigner contentSigner, SignerIdentifier signerIdentifier) throws OperatorCreationException {
        if (this.directSignature) {
            return new SignerInfoGenerator(signerIdentifier, contentSigner, this.digestProvider, this.sigEncAlgFinder, true);
        }
        if (this.signedGen != null || this.unsignedGen != null) {
            if (this.signedGen == null) {
                this.signedGen = new DefaultSignedAttributeTableGenerator();
            }
            return new SignerInfoGenerator(signerIdentifier, contentSigner, this.digestProvider, this.sigEncAlgFinder, this.signedGen, this.unsignedGen);
        }
        return new SignerInfoGenerator(signerIdentifier, contentSigner, this.digestProvider, this.sigEncAlgFinder);
    }
}

