/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.tls;

import io.pravega.keycloak.org.bouncycastle.crypto.agreement.DHStandardGroups;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DHParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.AbstractTlsServer;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsCipherFactory;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsCredentials;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsFatalAlert;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsKeyExchange;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsPSKIdentityManager;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsPSKIdentityManager tlsPSKIdentityManager) {
        this(new DefaultTlsCipherFactory(), tlsPSKIdentityManager);
    }

    public PSKTlsServer(TlsCipherFactory tlsCipherFactory, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCipherFactory);
        this.pskIdentityManager = tlsPSKIdentityManager;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    protected int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    public TlsCredentials getCredentials() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n) {
        return new TlsPSKKeyExchange(n, this.supportedSignatureAlgorithms, null, this.pskIdentityManager, null, this.getDHParameters(), this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

