/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.tls;

import io.pravega.keycloak.org.bouncycastle.crypto.DSA;
import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.signers.DSASigner;
import io.pravega.keycloak.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsDSASigner;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsDSSSigner
extends TlsDSASigner {
    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof DSAPublicKeyParameters;
    }

    protected DSA createDSAImpl(short s2) {
        return new DSASigner(new HMacDSAKCalculator(TlsUtils.createHash(s2)));
    }

    protected short getSignatureAlgorithm() {
        return 2;
    }
}

