/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.crypto.tls;

import io.pravega.keycloak.org.bouncycastle.crypto.DSA;
import io.pravega.keycloak.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.pravega.keycloak.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import io.pravega.keycloak.org.bouncycastle.crypto.signers.ECDSASigner;
import io.pravega.keycloak.org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsDSASigner;
import io.pravega.keycloak.org.bouncycastle.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof ECPublicKeyParameters;
    }

    protected DSA createDSAImpl(short s2) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(s2)));
    }

    protected short getSignatureAlgorithm() {
        return 3;
    }
}

