/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.bouncycastle.math.ec.custom.sec;

import io.pravega.keycloak.org.bouncycastle.math.ec.ECConstants;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECCurve;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECFieldElement;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECLookupTable;
import io.pravega.keycloak.org.bouncycastle.math.ec.ECPoint;
import io.pravega.keycloak.org.bouncycastle.math.ec.custom.sec.SecP160K1Point;
import io.pravega.keycloak.org.bouncycastle.math.ec.custom.sec.SecP160R2Curve;
import io.pravega.keycloak.org.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import io.pravega.keycloak.org.bouncycastle.math.raw.Nat160;
import io.pravega.keycloak.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP160K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = SecP160R2Curve.q;
    private static final int SECP160K1_DEFAULT_COORDS = 2;
    protected SecP160K1Point infinity = new SecP160K1Point(this, null, null);

    public SecP160K1Curve() {
        super(q);
        this.a = this.fromBigInteger(ECConstants.ZERO);
        this.b = this.fromBigInteger(BigInteger.valueOf(7L));
        this.order = new BigInteger(1, Hex.decode("0100000000000000000001B8FA16DFAB9ACA16B6B3"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    protected ECCurve cloneCurve() {
        return new SecP160K1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecP160K1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int[] nArray = new int[n2 * 5 * 2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n3);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n3 += 5);
            n3 += 5;
        }
        return new ECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n22 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n3 = (i ^ n) - 1 >> 31;
                    for (int j = 0; j < 5; ++j) {
                        int n4 = j;
                        nArray3[n4] = nArray3[n4] ^ nArray[n22 + j] & n3;
                        int n5 = j;
                        nArray2[n5] = nArray2[n5] ^ nArray[n22 + 5 + j] & n3;
                    }
                    n22 += 10;
                }
                return SecP160K1Curve.this.createRawPoint(new SecP160R2FieldElement(nArray3), new SecP160R2FieldElement(nArray2), false);
            }
        };
    }
}

