/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.keycloak.org.keycloak.crypto;

import io.pravega.keycloak.org.keycloak.crypto.JavaAlgorithm;
import io.pravega.keycloak.org.keycloak.crypto.KeyWrapper;
import io.pravega.keycloak.org.keycloak.crypto.SignatureException;
import io.pravega.keycloak.org.keycloak.crypto.SignatureSignerContext;
import java.security.PrivateKey;
import java.security.Signature;

public class AsymmetricSignatureSignerContext
implements SignatureSignerContext {
    private final KeyWrapper key;

    public AsymmetricSignatureSignerContext(KeyWrapper key) throws SignatureException {
        this.key = key;
    }

    @Override
    public String getKid() {
        return this.key.getKid();
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getHashAlgorithm() {
        return JavaAlgorithm.getJavaAlgorithmForHash(this.key.getAlgorithm());
    }

    @Override
    public byte[] sign(byte[] data) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(JavaAlgorithm.getJavaAlgorithm(this.key.getAlgorithm()));
            signature.initSign((PrivateKey)this.key.getPrivateKey());
            signature.update(data);
            return signature.sign();
        }
        catch (Exception e) {
            throw new SignatureException("Signing failed", e);
        }
    }
}

